% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ceteris_paribus.R
\name{ceteris_paribus}
\alias{ceteris_paribus}
\title{Ceteris Paribus}
\usage{
ceteris_paribus(explainer, observation, grid_points = 5,
  selected_variables = NULL)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the 'survxai::explain' function}

\item{observation}{a new observation for which predictions need to be explained}

\item{grid_points}{grid_points number of points used for response path}

\item{selected_variables}{if specified, then only these variables will be explained}
}
\value{
An object of the class surv_ceteris_paribus_explainer.
It's a data frame with calculated average responses.
}
\description{
The \code{ceteris_paribus()} function computes the predictions for the neighbor of our chosen observation. The neighbour is defined as the observations with changed value of one of the variable.
}
\examples{
\donttest{
library(survxai)
library(rms) 
data("pbcTrain")
data("pbcTest")
predict_times <- function(model, data, times){ 
                    prob <- rms::survest(model, data, times = times)$surv
                    return(prob)
                  }
cph_model <- cph(Surv(years, status)~., data = pbcTrain, surv = TRUE, x = TRUE, y=TRUE)
surve_cph <- explain(model = cph_model, data = pbcTest[,-c(1,5)], 
             y = Surv(pbcTest$years, pbcTest$status), 
             predict_function = predict_times)
cp_cph <- ceteris_paribus(surve_cph, pbcTest[1,-c(1,5)])
}
}
