% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{censor_event}
\alias{censor_event}
\alias{censor_time}
\title{Censor of events}
\usage{
censor_event(censor_time, time, event)

censor_time(censor_time, time)
}
\arguments{
\item{censor_time}{the time to censor}

\item{time}{the time variable where the censor_time is applied}

\item{event}{the variable with the event. It can be initialized in the
call with a value for all times.}
}
\value{
censored time or event
}
\description{
if censor_time < time, event is change to 0, otherwise not changed
}
\details{
if censor_time < time, time is changed to censor_time, otherwise no change

Be careful and do not overwrite the time variable with the censor time variable
to not loose track of the events
}
\section{Functions}{
\itemize{
\item \code{censor_time()}: Censor time

}}
\examples{
\dontshow{if ({FALSE}) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Typical workflow in a simulation of survival time.
# Simulate time to event (sim_t_event)
# and simulates the time to lost to follow up (tim_t_ltof)
# the simulation time frame is 1, so everything after 1 is censored

require(dplyr)
data.frame(
  sim_t_event = c(0.5,0.6,1,10,20),
  sim_t_ltof = c(2,0.5,2,2,0.8)
 ) |>
 mutate(sevent = censor_event(1,sim_t_event,sim_event=1)) |>
 mutate(stime = censor_time(1,sim_t_event)) |>
 mutate(event = censor_event(sim_t_ltof, stime, sevent)) |>
 mutate(timeto = censor_time(sim_t_ltof, stime))
\dontshow{\}) # examplesIf}
}
