% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{tribes_pal}
\alias{tribes_pal}
\alias{scale_fill_tribes}
\alias{scale_colour_tribes}
\title{Tribes colour palette}
\usage{
tribes_pal(season = NULL, scale_type = "d", reverse = FALSE, tribe = NULL, ...)

scale_fill_tribes(season = NULL, scale_type = "d", reverse = FALSE, ...)

scale_colour_tribes(season = NULL, scale_type = "d", reverse = FALSE, ...)
}
\arguments{
\item{season}{Season number}

\item{scale_type}{Discrete or continuous.  Input \code{d} or \code{c}.}

\item{reverse}{Logical. Reverse the palette?}

\item{tribe}{Tribe names. Default \code{NULL}}

\item{...}{Other arguments passed on to methods.}
}
\value{
Scale functions for ggplot2

Scale functions for ggplot2

Scale functions for ggplot2
}
\description{
To create scale functions for ggplot. Given a season of Survivor, a palette
is created from the tribe colours for that season including the merged tribe.
}
\details{
If it is intended the colours will correspond to the tribes e.g. a stacked bar chart
of votes given to each finalist and the colour corresponds to their original tribe (as in the
example below), the tribe vector needs to be passed to the scale function (for now). If no
tribe vector is given it will simply treat the tribe colours as a colour palette.
}
\examples{
library(ggplot2)
library(stringr)
library(dplyr)
library(glue)
ssn <- 35
labels <- castaways \%>\%
  filter(
    season == ssn,
    str_detect(result, "Sole|unner")
  ) \%>\%
  select(castaway, original_tribe) \%>\%
  mutate(label = glue("{castaway} ({original_tribe})")) \%>\%
  select(label, castaway)
jury_votes \%>\%
  filter(season == ssn) \%>\%
  left_join(
    castaways \%>\%
      filter(season == ssn) \%>\%
      select(castaway, original_tribe),
    by = "castaway"
  ) \%>\%
  group_by(finalist, original_tribe) \%>\%
  summarise(votes = sum(vote)) \%>\%
  left_join(labels, by = c("finalist" = "castaway")) \%>\% {
    ggplot(., aes(x = label, y = votes, fill = original_tribe)) +
      geom_bar(stat = "identity", width = 0.5) +
      scale_fill_tribes(ssn, tribe = .$original_tribe) +
      theme_minimal() +
      labs(
        x = "Finalist (original tribe)",
        y = "Votes",
        fill = "Original\ntribe",
        title = "Votes received by each finalist"
      )
 }
}
