% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WCH3df.R
\name{WCH3df}
\alias{WCH3df}
\title{Weighted cumulative hazard estimator for three gap times distribution 
function.}
\usage{
WCH3df(object, x, y, z)
}
\arguments{
\item{object}{An object of class multidf.}

\item{x}{The first time for obtaining estimates for the three gap times
distribution function.}

\item{y}{The second time for obtaining estimates for the three gap times 
distribution function.}

\item{z}{The third time for obtaining estimates for the three gap times 
distribution function.}
}
\value{
Vector with the Weighted cumulative hazard estimates for three gap 
times distribution function.
}
\description{
Provides estimates for three gap times distribution function 
based on Weighted cumulative hazard estimator (WCH).
}
\examples{
data("bladder5state")

b4state<-multidf(gap1=bladder5state$y1, event1=bladder4state$d1, 
                 gap2=bladder5state$y2, event2=bladder4state$d2,
                 gap3=bladder5state$y3, status=bladder4state$d3)
                 
head(b4state)[[1]]

WCH3df(b4state, x=13, y=20, z=40)

b4<-multidf(gap1=bladder4$t1, event1=bladder4$d1, 
            gap2=bladder4$t2-bladder4$t1, event2=bladder4$d2,
            gap3=bladder4$t3-bladder4$t2, status=bladder4state$d3)
              
WCH3df(b4, x=13, y=20, z=40)

}
\references{
Wang, M.C. and Wells, M.T. (1998). Nonparametric Estimation of 
successive duration times under dependent censoring, Biometrika 85, 561-572.
}
\seealso{
\code{\link{KMW3df}}, \code{\link{LIN3df}} and \code{\link{LDM3df}}.
}
\author{
Gustavo Soutinho and Luis Meira-Machado
}
