% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV1_60.r
\name{summary.survPen}
\alias{summary.survPen}
\title{Summary for a \code{survPen} fit}
\usage{
\method{summary}{survPen}(object, ...)
}
\arguments{
\item{object}{a fitted \code{survPen} object as produced by \code{\link{survPen.fit}}}

\item{...}{other arguments}
}
\value{
List of objects:
\item{call}{the original survPen call}
\item{formula}{the original survPen formula}
\item{coefficients}{reports the regression parameters estimates for unpenalized terms with the associated standard errors}
\item{edf.per.smooth}{reports the edf associated with each smooth term}
\item{random}{TRUE if there are random effects in the model}
\item{random.effects}{reports the estimates of the log standard deviation (log(sd)) of every random effects plus the estimated standard error (also on the log(sd) scale)}
\item{likelihood}{unpenalized likelihood of the model}
\item{penalized.likelihood}{penalized likelihood of the model}
\item{nb.smooth}{number of smoothing parameters}
\item{smoothing.parameter}{smoothing parameters estimates}
\item{parameters}{number of regression parameters}
\item{edf}{effective degrees of freedom}
\item{method}{smoothing selection criterion used (LAML or LCV)}
\item{val.criterion}{minimized value of criterion. For LAML, what is reported is the negative log marginal likelihood}
\item{converged}{convergence indicator, TRUE or FALSE. TRUE if Hess.beta.modif=FALSE and Hess.rho.modif=FALSE (or NULL)}
}
\description{
Takes a fitted \code{survPen} object and produces various useful summaries from it.
}
\examples{

library(survPen)

data(datCancer) # simulated dataset with 2000 individuals diagnosed with cervical cancer

# model : unidimensional penalized spline for time since diagnosis with 5 knots
f1 <- ~smf(fu,df=5)

# fitting hazard model
mod1 <- survPen(f1,data=datCancer,t1=fu,event=dead,expected=NULL,method="LAML")

# summary
summary(mod1)

}
