% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV1_51.r
\name{tensor.prod.X}
\alias{tensor.prod.X}
\title{tensor model matrix}
\usage{
tensor.prod.X(X)
}
\arguments{
\item{X}{list of m design matrices with n rows and p1, p2, ... pm columns respectively}
}
\value{
\item{T}{Matrix of dimensions n*(p1*p2*...*pm) representing the row tensor product of the matrices in X}
}
\description{
Computes the model matrix of tensor product smooth from the marginal bases.
}
\examples{

library(survPen)

# row-wise tensor product between three design matrices
set.seed(15)

X1 <- matrix(rnorm(10*3),nrow=10,ncol=3)
X2 <- matrix(rnorm(10*2),nrow=10,ncol=2)
X3 <- matrix(rnorm(10*2),nrow=10,ncol=2)
tensor.prod.X(list(X1,X2,X3))

}
