% Generated by roxygen2 (4.0.1): do not edit by hand
\name{as.Surv}
\alias{as.Surv}
\title{Convert \code{time} and \code{status} to a
right-censored survival object, ordered by time}
\usage{
as.Surv(ti, st)
}
\arguments{
\item{ti}{Vector of time points}

\item{st}{Vector of status (e.g. death) at time points}
}
\value{
An object of class \code{Surv}.
}
\description{
Convert \code{time} and \code{status} to a
right-censored survival object, ordered by time
}
\details{
A traditional \code{Surv} object will only allow discrete events,
i.e. status \eqn{s \in N}{s = Natural number}.
Typically, \eqn{s \in \{0,1\}}{s = 0|1}.
\cr
There may be times when allowing non-binary values is of interest,
e.g. in constructing \emph{expected} survival.
\cr
Caution is required when using this function with functions that
assume binary values for \code{status}.
}
\examples{
c1 <- coxph(formula = Surv(time, status == 2) ~ age + log(bili), data=pbc)
E <- predict(c1, type="expected")
as.Surv(pbc$time, E)
\dontrun{
summary(coxph(as.Surv(pbc$time, E) ~ log(pbc$bili)))
### Warning:
### In Surv(stime, sstat) : Invalid status value, converted to NA}
}
\seealso{
\code{\link{dx}}
\cr
\code{?survival::Surv}
}

