% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.fit.plot.R
\name{model.fit.plot}
\alias{model.fit.plot}
\title{Graphical representation of the measures of model fitting based on
Information Criteria}
\usage{
model.fit.plot(..., type = "aic", scale = "absolute", stacked = FALSE)
}
\arguments{
\item{...}{Optional inputs. Must include at least one \code{survHE} object.}

\item{type}{should the AIC, the BIC or the DIC plotted? (values = \code{"aic"},
\code{"bic"} or \code{"dic"})}

\item{scale}{If \code{scale='absolute'} (default), then plot the absolute value 
of the *IC. If \code{scale='relative'} then plot a rescaled version taking
the percentage increase in the *IC in comparison with the best-fitting model}

\item{stacked}{Should the bars be stacked and grouped by survHE object? (default=F)}
}
\value{
A plot with the relevant model fitting statistics
}
\description{
Plots a summary of the model fit for all the models fitted
}
\details{
Something will go here
}
\examples{

data(bc)

mle = fit.models(formula=Surv(recyrs,censrec)~group,data=bc,
    distr=c("exp","wei","lno"),method="mle")
model.fit.plot(mle)

}
\references{
G Baio (2019). survHE: Survival analysis for health economic evaluation 
and cost-effectiveness modelling. Journal of Statistical Software (2020). vol 95,
14, 1-47. <doi:10.18637/jss.v095.i14>
}
\seealso{
\code{fit.models}
}
\author{
Gianluca Baio
}
\keyword{Model}
\keyword{Parametric}
\keyword{fitting}
\keyword{models}
\keyword{survival}
