% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit.R
\name{choose_indention}
\alias{choose_indention}
\title{Choose the indention method for the tokens}
\usage{
choose_indention(flattened_pd, use_raw_indention)
}
\arguments{
\item{flattened_pd}{A nested parse table that was turned into a flat parse
table using \code{\link[=extract_terminals]{extract_terminals()}}.}

\item{use_raw_indention}{Boolean indicating whether or not the raw indention
should be used.}
}
\description{
Either use the raw indention, which is just the spaces computed between
the first token on a new line and the token before it, or use the indention
computed according to the transformer used, which is stored in the column
\code{indention}.
All indention information will be combined with the space information for
the first token on a new line.
If \code{use_raw_indention} is set, information in the column \code{indention} will
be discarded anyways. If it is not set, the first token on a new line will
"inherit" the indention of the whole line.
The column \code{indention} will be removed since all information necessary is
contained in the spacing information of the first token on a new line and
the position of the tokens will not be changed anymore at this stage.
}
\keyword{internal}
