% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateT.r
\name{calculateT}
\alias{calculateT}
\title{Calculate Stochastic Threshold}
\usage{
calculateT(data, log.model = FALSE, p.dropout = 0.01,
  pred.int = 0.95, debug = FALSE)
}
\arguments{
\item{data}{data.frame with dependent and explanatory values in columns named 'Dep' and 'Exp'.}

\item{log.model}{logical indicating if data should be log tranformed. Default=FALSE.}

\item{p.dropout}{numeric accepted risk to calculate point estimate for. Default=0.01.}

\item{pred.int}{numeric prediction interval. Default=0.95.}

\item{debug}{logical indicating printing debug information.}
}
\value{
vector with named parameters
}
\description{
Calculates point estimates for the stochastic threshold.
}
\details{
Given a data.frame with observed values for the dependent variable
(column 'Dep') and explanary values (column 'Exp') point estimates
corresponding to a risk level of \code{p.dropout} are calculated 
using logistic regression: \code{glm(Dep~Exp, family=binomial("logit")}.
A conservative estimate is calculated from the \code{pred.int}.
In addition the model parameters B0 (intercept) and B1 (slope),
Hosmer-Lemeshow test statistic (p-value), and the number of observed
and dropped out alleles is returned.
}
\seealso{
\code{\link{calculateDropout}}, \code{\link{calculateAllT}},
 \code{\link{modelDropout_gui}}, \code{\link{plotDropout_gui}}
}
