% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateRatio.r
\name{calculateRatio}
\alias{calculateRatio}
\title{Calculate Ratio}
\usage{
calculateRatio(data, ref = NULL, numerator = NULL, denominator = NULL,
  group = NULL, ol.rm = TRUE, ignore.case = TRUE, word = FALSE,
  exact = FALSE, debug = FALSE)
}
\arguments{
\item{data}{a data frame containing at least
'Sample.Name', 'Marker', 'Height', 'Allele'.}

\item{ref}{a data frame containing at least 'Sample.Name', 'Marker', 'Allele'.
If provided alleles matching 'ref' will be extracted from 'data'
(see \code{\link{filterProfile}}).}

\item{numerator}{character vector with marker names.}

\item{denominator}{character vector with marker names.}

\item{group}{character column name to group by.}

\item{ol.rm}{logical indicating if off-ladder 'OL' alleles should be removed.}

\item{ignore.case}{logical indicating if sample matching should ignore case.}

\item{word}{logical indicating if word boundaries should be added before sample matching.}

\item{exact}{logical indicating if exact sample matching should be used.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with with columns 'Sample.Name', 'Marker', 'Delta', 'Hb', 'Lb', 'MPH', 'TPH'.
}
\description{
Calculates the peak height ratio between specified loci.
}
\details{
Default is to calculate the ratio between all unique pairwise
combinations of markers/loci. If equal number of markers are provided in
the numerator and the denominator the provided pairwise ratios will be
calculated. If markers are provided in only the numerator or only the
denominator the ratio of all possible combinations of the provided markers
and the markers not provided will be calculated. If the number of markers
provided are different in the numerator and in the denominator the shorter
vector will be repeated to equal the longer vector in length.
Data can be unfiltered or filtered since the sum of 
peak heights per marker is used. Off-ladder alleles is by default removed
from the dataset before calculations.
}
\examples{
data(set2)
# Calculate ratio between the shortest and longest marker in each dye.
numerator <- c("D3S1358", "AMEL","D19S433")
denominator <- c("D2S1338", "D18S51", "FGA")
calculateRatio(data=set2, numerator=numerator, denominator=denominator)
calculateRatio(data=set2, numerator=NULL, denominator="AMEL")
calculateRatio(data=set2, numerator=c("AMEL","TH01"), denominator=NULL)
calculateRatio(data=set2, numerator=NULL, denominator=NULL)
}
