% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateResultType.r
\name{calculateResultType}
\alias{calculateResultType}
\title{Calculate Result Type}
\usage{
calculateResultType(data, kit = NULL, add.missing.marker = TRUE,
  threshold = NULL, mixture.limits = NULL, partial.limits = NULL,
  subset.name = NA, marker.subset = NULL, debug = FALSE)
}
\arguments{
\item{data}{a data frame containing at least the column 'Sample.Name'.}

\item{kit}{character string or integer defining the kit.}

\item{add.missing.marker}{logical, defualt is TRUE which adds missing markers.}

\item{threshold}{integer indicating the dropout threshold.}

\item{mixture.limits}{integer or vector indicating subtypes of 'Mixture'.}

\item{partial.limits}{integer or vector indicating subtypes of 'Partial'.}

\item{subset.name}{string naming the subset of 'Complete'.}

\item{marker.subset}{string with marker names defining the subset of 'Complete'.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with columns 'Sample.Name','Type', and 'Subtype'.
}
\description{
Calculate the result type for samples.
}
\details{
Calculates result types for samples in 'data'.
Defined types are: 'No result', 'Mixture', 'Partial', and 'Complete'.
Subtypes can be defined by parameters.
An integer passed to 'threshold' defines a subtype of 'Complete' "Complete profile all peaks >threshold".
An integer or vector passed to 'mixture.limits' define subtypes of 'Mixture' "> [mixture.limits] markers".
An integer or vector passed to 'partial.limits' define subtypes of 'Partial' "> [partial.limits] peaks".
A string with marker names separated by pipe (|) passed to 'marker.subset' and
 a string 'subset.name' defines a subtype of 'Partial' "Complete [subset.name]".
}

