% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strwrap.R
\name{strwrap}
\alias{strwrap}
\title{Word-Wrap Text}
\usage{
strwrap(
  x,
  width = 0.9 * getOption("width"),
  indent = 0,
  exdent = 0,
  prefix = "",
  simplify = TRUE,
  initial = prefix,
  locale = NULL
)
}
\arguments{
\item{x}{character vector whose elements are to be word-wrapped}

\item{width}{single integer; maximal total width of the code points
per line (as determined by \code{\link[stringi]{stri_width}})}

\item{indent}{single integer; first line indentation size}

\item{exdent}{single integer; consequent lines indentation size}

\item{prefix}{single string; prefix for each line except the first}

\item{simplify}{see Value}

\item{initial}{single string; prefix for the first line}

\item{locale}{\code{NULL} or \code{""} for the default locale
(see \code{\link[stringi]{stri_locale_get}})
or a single string with a locale identifier,
see \code{\link[stringi]{stri_locale_list}}}
}
\value{
If \code{simplify} is \code{FALSE}, a list of \code{length(x)} numeric
vectors is returned.

Otherwise, the function yields a character vector (in UTF-8).
Note that the length of the output may be different
than that of the input.

Due to this, no attributes are preserved.
}
\description{
Splits each string into words which are then arranged to form text lines
of mo more than a given width.
}
\details{
Might be useful when displaying strings using a monospaced font.
}
\section{Differences from Base R}{

Replacement for base \code{\link[base]{strwrap}}
implemented with \code{\link[stringi]{stri_wrap}}.

\itemize{
\item missing values not propagated
    \bold{[fixed here]}
\item some emojis, combining characters and modifiers (e.g., skin tones)
   are not recognised properly
    \bold{[fixed here]}
\item what is considered a word does not depend on locale
    \bold{[fixed here - using \pkg{ICU}'s word break iterators]}
\item multiple whitespaces between words are not preserved except after
    a dot, question mark, or exclamation mark,
    which leads to two spaces inserted
    \bold{[changed here -- any sequence of whitespaces considered
    word boundaries is converted to a single space]}
\item a greedy word wrap algorithm is used, which may lead to high
    raggedness
    \bold{[fixed here -- using the Knuth-Plass method]}
}
}

\examples{
strwrap(paste0(
    strrep("az ", 20),
    strrep("\u0105\u20AC ", 20),
    strrep("\U0001F643 ", 20),
    strrep("\U0001F926\U0000200D\U00002642\U0000FE0F ", 20)
), width=60)


}
\references{
D.E. Knuth, M.F. Plass,
Breaking paragraphs into lines,
\emph{Software: Practice and Experience} 11(11),
1981, pp. 1119--1184.
}
\seealso{
The official online manual of \pkg{stringx} at \url{https://stringx.gagolewski.com/}

Related function(s): \code{\link{sprintf}}, \code{\link{trimws}},
\code{\link{nchar}}
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
