% Generated by roxygen2 (4.0.0): do not edit by hand
\name{stri_replace_all_fixed}
\alias{stri_replace_all_fixed}
\alias{stri_replace_first_fixed}
\alias{stri_replace_last_fixed}
\title{Replace Occurrences of a Fixed Pattern Matches}
\usage{
stri_replace_all_fixed(str, pattern, replacement)

stri_replace_first_fixed(str, pattern, replacement)

stri_replace_last_fixed(str, pattern, replacement)
}
\arguments{
\item{str}{character vector of strings to search in}

\item{pattern}{character vector of patterns to search for}

\item{replacement}{character vector of strings to replace with}
}
\value{
Each function returns a character vector.
}
\description{
Replaces with the given replacement string every/first/last
substring of the input that matches the pattern.
}
\details{
Vectorized over \code{str}, \code{pattern}, and \code{replacement}.

For natural language processing this function may be not give
you desired results. Refer to \link{stringi-search-fixed} for more details.

These functions scan the input string for matches of the pattern.
Input that is not part of any match is left unchanged;
each match is replaced in the result by the replacement string.
}
\examples{
s <- "Lorem ipsum dolor sit amet, consectetur adipisicing elit."
stri_replace_all_fixed(s, " ", "#")
stri_replace_all_fixed(s, "o", "0")
}
\seealso{
Other search_fixed: \code{\link{stri_count_fixed}};
  \code{\link{stri_detect_fixed}};
  \code{\link{stri_locate_all_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_last_fixed}},
  \code{\link{stri_locate_last_fixed}};
  \code{\link{stri_split_fixed}};
  \code{\link{stringi-search-fixed}};
  \code{\link{stringi-search}}

Other search_replace: \code{\link{stri_replace_all_charclass}},
  \code{\link{stri_replace_first_charclass}},
  \code{\link{stri_replace_first_charclass}},
  \code{\link{stri_replace_last_charclass}},
  \code{\link{stri_replace_last_charclass}};
  \code{\link{stri_replace_all_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_last_coll}},
  \code{\link{stri_replace_last_coll}};
  \code{\link{stri_replace_all_regex}},
  \code{\link{stri_replace_first_regex}},
  \code{\link{stri_replace_first_regex}},
  \code{\link{stri_replace_last_regex}},
  \code{\link{stri_replace_last_regex}};
  \code{\link{stri_replace_all}};
  \code{\link{stri_replace_first}};
  \code{\link{stri_replace_last}};
  \code{\link{stri_replace_na}};
  \code{\link{stri_replace}}; \code{\link{stringi-search}}
}

