% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-nums.R
\name{str_extract_numbers}
\alias{str_extract_numbers}
\alias{str_nth_number}
\alias{str_first_number}
\alias{str_last_number}
\title{Extract numbers from a string.}
\usage{
str_extract_numbers(string, leave_as_string = FALSE, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE)

str_nth_number(string, n, leave_as_string = FALSE, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE)

str_first_number(string, leave_as_string = FALSE, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE)

str_last_number(string, leave_as_string = FALSE, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE)
}
\arguments{
\item{string}{A string.}

\item{leave_as_string}{Do you want to return the number as a string (\code{TRUE})
or as numeric (\code{FALSE}, the default)?}

\item{decimals}{Do you want to include the possibility of decimal numbers
(\code{TRUE}) or not (\code{FALSE}, the default).}

\item{leading_decimals}{Do you want to allow a leading decimal point to be
the start of a number?}

\item{negs}{Do you want to allow negative numbers? Note that double negatives
are not handled here (see the examples).}

\item{n}{The index of the number (or non-numeric) that you seek. Negative
indexing is allowed i.e. \code{n = 1} (the default) will give you the first
number (or non-numeric) whereas \code{n = -1} will give you the last number (or
non-numeric), \code{n = -2} will give you the second last number and so on. The
function is vectorized over this argument.}
}
\value{
For \code{str_extract_numbers} and \code{extract_non_numerics}, a list of
numeric or character vectors, one list element for each element of
\code{string}. For \code{str_nth_number} and \code{nth_non_numeric}, a vector the same
length as \code{string} (as in \code{length(string)}, not \code{nchar(string)}).
}
\description{
\code{str_extract_numbers} extracts the numbers (or non-numbers) from a string
where decimals are optionally allowed. \code{str_nth_number} is a convenient
wrapper for \code{str_extract_numbers}, allowing you to choose which number you
want. Please run the examples at the bottom of this page to ensure that you
understand how these functions work, and their limitations. These functions
are vectorized over \code{string}.
}
\details{
If any part of a string contains an ambiguous number (e.g. \code{1.2.3} would be
ambiguous if \code{decimals = TRUE} (but not otherwise)), the value returned for
that string will be \code{NA}. Note that these functions do not know about
scientific notation (e.g. \code{1e6} for 1000000).

\itemize{ \item \code{str_first_number(...)} is just \code{str_nth_number(..., n = 1)}.
\item \code{str_last_number(...)} is just \code{str_nth_number(..., n = -1)}. }
}
\examples{
str_extract_numbers(c("abc123abc456", "abc1.23abc456"))
str_extract_numbers(c("abc1.23abc456", "abc1..23abc456"), decimals = TRUE)
str_extract_numbers("abc1..23abc456", decimals = TRUE)
str_extract_numbers("abc1..23abc456", decimals = TRUE, leading_decimals = TRUE)
str_extract_numbers("abc1..23abc456", decimals = TRUE, leading_decimals = TRUE,
                leave_as_string = TRUE)
str_extract_numbers("-123abc456")
str_extract_numbers("-123abc456", negs = TRUE)
str_extract_numbers("--123abc456", negs = TRUE)
str_extract_numbers(c(rep("abc1.2.3", 2), "a1b2.2.3", "e5r6"), decimals = TRUE)
str_extract_numbers("ab.1.2", decimals = TRUE, leading_decimals = TRUE)
str_nth_number("abc1.23abc456", 2:3)
str_nth_number("abc1.23abc456", 2, decimals = TRUE)
str_nth_number("-123abc456", -2, negs = TRUE)

}
