% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stress_survival_conversion.R
\name{Stressconversion}
\alias{Stressconversion}
\alias{survival_to_stress}
\alias{stress_to_survival}
\title{Convert Between Stress and Survival}
\usage{
survival_to_stress(survival, p = 3.2, q = 3.2)

stress_to_survival(stress, p = 3.2, q = 3.2)
}
\arguments{
\item{survival}{One or more survival values to convert to general stress.
Should be a value between 0 and 1. Smaller or bigger values are treated as
0 or 1 respectively.}

\item{p, q}{The shape parameters of the \code{\link[stats:Beta]{beta}}
distribution. Default is 3.2.}

\item{stress}{One or more stress values to convert to survival.}
}
\value{
\code{stress_to_survival} returns a vector the same length as
  \code{stress} giving the survival caused by each amount of stress.

  \code{survival_to_stress} returns a vector the same length as
  \code{survival} containing the stress values associated with each survival.
}
\description{
Functions to convert survival to general stress or vice versa using the beta
distribution.
}
\details{
These are simple wrappers around the beta distribution function
\code{\link[stats:Beta]{pbeta}} and the beta quantile function
\code{\link[stats:Beta]{qbeta}}.
}
\examples{
stress <- 0.3
survival <- stress_to_survival(stress)
survival_to_stress(survival)

}
