% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streambugs_aux.r
\name{construct.statevariables}
\alias{construct.statevariables}
\title{Construct the streambugs ODE state variable names}
\usage{
construct.statevariables(Reaches, Habitats, POM = NULL, Algae = NULL,
  Invertebrates = NULL)
}
\arguments{
\item{Reaches}{reach names character vector; duplicates are dropped}

\item{Habitats}{habitats names character vector; duplicates are dropped}

\item{POM}{optional ("taxa") character vector of POM (particulate organic matter) group;
duplicates are dropped
(note: at least one "taxon" name out of all groups has to be given)}

\item{Algae}{optional taxa character vector of Algae group; duplicates are
dropped (note: at least one taxon name out of all groups has to be given)}

\item{Invertebrates}{optional taxa character vector of Invertebrates group
duplicates are dropped (note: at least one taxon name out of all groups has}
}
\value{
vector with state variable names in the form of
   \code{"Reach_Habitat_Taxon_Group"}
}
\description{
Construct encoded labels of streambugs ODE state variable names from reach
names, habitat names, and "taxa" names for at least one of the POM, Algae, or
Invertebrates groups.
}
\examples{
Reaches           <- paste0("Reach",1:2)
Habitats          <- paste0("Hab",1:1)
y.names <- construct.statevariables(Reaches,Habitats,Invertebrates=c("Baetis","Ecdyonurus"))

}
