/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import java.awt.Graphics;
import javax.swing.JPanel;
import moa.evaluation.MeasureCollection;
import moa.gui.visualization.AbstractGraphAxes;
import moa.gui.visualization.AbstractGraphPlot;

public abstract class AbstractGraphCanvas
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected MeasureCollection[] measures;
    protected MeasureCollection[] measureStds;
    protected int measureSelected;
    protected AbstractGraphAxes axesPanel;
    protected AbstractGraphPlot plotPanel;
    protected static final int X_OFFSET_LEFT = 35;
    protected static final int X_OFFSET_RIGHT = 15;
    protected static final int Y_OFFSET_BOTTOM = 20;
    protected static final int Y_OFFSET_TOP = 20;
    protected double min_x_value;
    protected double max_x_value;
    protected double max_y_value;
    protected double x_resolution;
    protected double y_resolution;
    protected double baseWidth;
    protected double baseHeight;

    public AbstractGraphCanvas(AbstractGraphAxes ax, AbstractGraphPlot g) {
        this.axesPanel = ax;
        this.plotPanel = g;
        this.measureSelected = 0;
        this.plotPanel.setLocation(36, 20);
        this.add(this.axesPanel);
        this.axesPanel.add(this.plotPanel);
        this.min_x_value = 0.0;
        this.max_x_value = 1.0;
        this.max_y_value = 1.0;
        this.x_resolution = 1.0;
        this.y_resolution = 1.0;
        this.updateXResolution();
        this.updateYResolution();
        this.baseWidth = this.getWidth();
        this.baseHeight = this.getHeight();
    }

    public void setStandardDeviationPainted(boolean b) {
        this.plotPanel.setStandardDeviationPainted(b);
    }

    private void updateBaseWidth() {
        this.baseWidth = this.x_resolution > 1.0 ? (double)this.getWidth() / this.x_resolution : 500.0;
    }

    private void updateBaseHeight() {
        this.baseHeight = this.y_resolution > 1.0 ? (double)this.getHeight() / this.y_resolution : 111.0;
    }

    public void scaleXResolution(double factor) {
        this.x_resolution *= factor;
        this.updateXResolution();
        this.updateLowerXValue();
        this.updateUpperXValue();
        this.updateCanvas(true);
    }

    public void scaleYResolution(double factor) {
        this.y_resolution = Math.max(1.0, this.y_resolution * factor);
        this.updateYResolution();
        this.updateUpperYValue();
        this.updateCanvas(true);
    }

    public void setMeasureSelected(int selected) {
        this.measureSelected = selected;
        this.plotPanel.setMeasureSelected(selected);
    }

    public void updateCanvas(boolean force) {
        if (this.updateMinMaxValues() || force) {
            this.setSize();
            this.setPreferredSize();
            this.repaint();
        }
    }

    public abstract void setSize();

    public abstract void setPreferredSize();

    private double getMaxSelectedValue() {
        double max = Double.MIN_VALUE;
        for (int i = 0; i < this.measures.length; ++i) {
            if (!(this.measures[i].getMaxValue(this.measureSelected) > max)) continue;
            max = this.measures[i].getMaxValue(this.measureSelected);
        }
        return max;
    }

    public abstract double getMinXValue();

    public abstract double getMaxXValue();

    private boolean updateMinMaxValues() {
        double max_y_value_new;
        double max_x_value_new;
        double min_x_value_new;
        if (this.measures == null) {
            min_x_value_new = 0.0;
            max_x_value_new = 1.0;
            max_y_value_new = 1.0;
        } else {
            min_x_value_new = this.getMinXValue();
            max_x_value_new = this.getMaxXValue();
            max_y_value_new = this.getMaxSelectedValue();
        }
        if (min_x_value_new != this.min_x_value || max_x_value_new != this.max_x_value || max_y_value_new != this.max_y_value) {
            this.min_x_value = min_x_value_new;
            this.max_x_value = max_x_value_new;
            this.max_y_value = max_y_value_new;
            this.updateMinXValue();
            this.updateMaxXValue();
            this.updateMaxYValue();
            this.updateLowerXValue();
            this.updateUpperXValue();
            this.updateUpperYValue();
            return true;
        }
        return false;
    }

    private void updateXResolution() {
        this.axesPanel.setXResolution(this.x_resolution);
        this.plotPanel.setXResolution(this.x_resolution);
    }

    private void updateYResolution() {
        this.axesPanel.setYResolution(this.y_resolution);
    }

    private void updateMinXValue() {
        this.axesPanel.setMinXValue(this.min_x_value);
        this.plotPanel.setMinXValue(this.min_x_value);
    }

    private void updateMaxXValue() {
        this.axesPanel.setMaxXValue(this.max_x_value);
        this.plotPanel.setMaxXValue(this.max_x_value);
    }

    private void updateMaxYValue() {
        this.axesPanel.setMaxYValue(this.max_y_value);
        this.plotPanel.setMaxYValue(this.max_y_value);
    }

    private void updateLowerXValue() {
        double lower = 0.0;
        if (this.measures != null) {
            lower = this.min_x_value * (1.0 - 0.1 / this.x_resolution);
        }
        this.axesPanel.setLowerXValue(lower);
        this.plotPanel.setLowerXValue(lower);
    }

    private void updateUpperXValue() {
        double upper = 1.0;
        if (this.measures != null) {
            upper = this.max_x_value * (1.0 + 0.1 / this.x_resolution);
        }
        this.axesPanel.setUpperXValue(upper);
        this.plotPanel.setUpperXValue(upper);
    }

    private void updateUpperYValue() {
        double upper = 1.0;
        if (this.measures != null) {
            upper = this.max_y_value * (1.0 + 0.1 / this.y_resolution);
        }
        this.axesPanel.setUpperYValue(upper);
        this.plotPanel.setUpperYValue(upper);
    }

    private void updateChildren() {
        this.axesPanel.setSize(this.getWidth(), this.getHeight());
        this.plotPanel.setSize(this.getWidth() - 35 - 15, this.getHeight() - 20 - 20);
    }

    @Override
    protected void paintChildren(Graphics g) {
        this.updateBaseHeight();
        this.updateBaseWidth();
        this.updateChildren();
        super.paintChildren(g);
    }
}

