/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.driftdetection;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import moa.classifiers.core.driftdetection.AbstractChangeDetector;
import moa.core.ObjectRepository;
import moa.tasks.TaskMonitor;
import weka.core.Statistics;

public class STEPD
extends AbstractChangeDetector {
    private static final long serialVersionUID = -3518369648142099719L;
    public IntOption windowSizeOption = new IntOption("windowSize", 'r', "Recent Window Size.", 30, 0, 1000);
    public FloatOption alphaDriftOption = new FloatOption("alphaDrift", 'o', "Drift Significance Level.", 0.003, 0.0, 1.0);
    public FloatOption alphaWarningOption = new FloatOption("alphaWarning", 'w', "Warning Significance Level.", 0.05, 0.0, 1.0);
    private int windowSize;
    private double alphaDrift;
    private double alphaWarning;
    private byte[] storedPredictions;
    private int firstPos;
    private int lastPos;
    private double ro;
    private double rr;
    private double wo;
    private double wr;
    private int no;
    private int nr;
    private double p;
    private double Z;
    private double sizeInvertedSum;

    public void initialize() {
        this.windowSize = this.windowSizeOption.getValue();
        this.alphaDrift = this.alphaDriftOption.getValue();
        this.alphaWarning = this.alphaWarningOption.getValue();
        this.storedPredictions = new byte[this.windowSize];
        this.resetLearning();
    }

    @Override
    public void resetLearning() {
        this.firstPos = 0;
        this.lastPos = -1;
        this.wr = 0.0;
        this.wo = 0.0;
        this.nr = 0;
        this.no = 0;
        this.isChangeDetected = false;
    }

    @Override
    public void input(double prediction) {
        if (!this.isInitialized) {
            this.initialize();
            this.isInitialized = true;
        } else if (this.isChangeDetected) {
            this.resetLearning();
        }
        if (this.nr == this.windowSize) {
            this.wo += (double)this.storedPredictions[this.firstPos];
            ++this.no;
            this.wr -= (double)this.storedPredictions[this.firstPos];
            ++this.firstPos;
            if (this.firstPos == this.windowSize) {
                this.firstPos = 0;
            }
        } else {
            ++this.nr;
        }
        ++this.lastPos;
        if (this.lastPos == this.windowSize) {
            this.lastPos = 0;
        }
        this.storedPredictions[this.lastPos] = (byte)prediction;
        this.wr += prediction;
        this.isWarningZone = false;
        if (this.no >= this.windowSize) {
            this.ro = (double)this.no - this.wo;
            this.rr = (double)this.nr - this.wr;
            this.sizeInvertedSum = 1.0 / (double)this.no + 1.0 / (double)this.nr;
            this.p = (this.ro + this.rr) / (double)(this.no + this.nr);
            this.Z = Math.abs(this.ro / (double)this.no - this.rr / (double)this.nr);
            this.Z -= this.sizeInvertedSum / 2.0;
            this.Z /= Math.sqrt(this.p * (1.0 - this.p) * this.sizeInvertedSum);
            this.Z = Statistics.normalProbability((double)Math.abs(this.Z));
            this.Z = 2.0 * (1.0 - this.Z);
            if (this.Z < this.alphaDrift) {
                this.isChangeDetected = true;
            } else if (this.Z < this.alphaWarning) {
                this.isWarningZone = true;
            }
        }
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }
}

