/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.macro.dbscan;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import moa.cluster.CFCluster;
import moa.cluster.Cluster;
import moa.cluster.Clustering;
import moa.clusterers.macro.AbstractMacroClusterer;
import moa.clusterers.macro.NonConvexCluster;
import moa.clusterers.macro.dbscan.DenseMicroCluster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBScan
extends AbstractMacroClusterer {
    Clustering datasource;
    private double mEps;
    private int mMinPts;

    public DBScan(Clustering microClusters, double eps, int MinPts) {
        this.datasource = microClusters;
        this.mEps = eps;
        this.mMinPts = MinPts;
    }

    private ArrayList<DenseMicroCluster> expandCluster(DenseMicroCluster dmc, List<DenseMicroCluster> neighbours, ArrayList<DenseMicroCluster> arrayList, Vector<DenseMicroCluster> dbmc) {
        if (!dmc.isClustered()) {
            dmc.setClustered();
            arrayList.add(dmc);
        }
        while (!neighbours.isEmpty()) {
            DenseMicroCluster mc = neighbours.get(0);
            neighbours.remove(0);
            if (mc.isVisited()) continue;
            mc.setVisited();
            List<DenseMicroCluster> neighbours2 = this.getNeighbourhood(mc, dbmc);
            if (neighbours2.size() < this.mMinPts) continue;
            while (!neighbours2.isEmpty()) {
                DenseMicroCluster temp = neighbours2.get(0);
                neighbours2.remove(0);
                if (temp.isVisited()) continue;
                neighbours.add(temp);
            }
            neighbours.addAll(neighbours2);
            if (mc.isClustered()) continue;
            mc.setClustered();
            arrayList.add(mc);
        }
        return arrayList;
    }

    private List<DenseMicroCluster> getNeighbourhood(DenseMicroCluster mc, Vector<DenseMicroCluster> dbmc) {
        Vector<DenseMicroCluster> res = new Vector<DenseMicroCluster>();
        for (DenseMicroCluster dmc : dbmc) {
            if (!(this.distance(dmc.getCFCluster().getCenter(), mc.getCFCluster().getCenter()) < this.mEps)) continue;
            res.add(dmc);
        }
        return res;
    }

    private double distance(double[] center, double[] center2) {
        double d = 0.0;
        for (int i = 0; i < center.length; ++i) {
            d += Math.pow(center[i] - center2[i], 2.0);
        }
        return Math.sqrt(d);
    }

    @Override
    public Clustering getClustering(Clustering microClusters) {
        if (microClusters != null && microClusters.size() != 0) {
            Vector<DenseMicroCluster> dbmc = new Vector<DenseMicroCluster>();
            for (Cluster c : microClusters.getClustering()) {
                CFCluster cf = null;
                if (c instanceof CFCluster) {
                    cf = (CFCluster)c;
                    dbmc.add(new DenseMicroCluster(cf));
                    continue;
                }
                throw new RuntimeException();
            }
            ArrayList<ArrayList<DenseMicroCluster>> clusters = new ArrayList<ArrayList<DenseMicroCluster>>();
            for (DenseMicroCluster dmc : dbmc) {
                if (dmc.isVisited()) continue;
                dmc.setVisited();
                List<DenseMicroCluster> neighbours = this.getNeighbourhood(dmc, dbmc);
                if (neighbours.size() < this.mMinPts) continue;
                ArrayList<DenseMicroCluster> cluster = this.expandCluster(dmc, neighbours, new ArrayList<DenseMicroCluster>(), dbmc);
                clusters.add(cluster);
            }
            Cluster[] res = new CFCluster[clusters.size()];
            int clusterPos = 0;
            for (ArrayList<DenseMicroCluster> cluster : clusters) {
                if (cluster.size() == 0) continue;
                NonConvexCluster temp = new NonConvexCluster(((DenseMicroCluster)cluster.get(0)).getCFCluster(), this.Convert2microclusterList(cluster));
                res[clusterPos] = temp;
                for (int i = 1; i < cluster.size(); ++i) {
                    ((CFCluster)res[clusterPos]).add(cluster.get(i).getCFCluster());
                }
                ++clusterPos;
            }
            int noise = 0;
            for (DenseMicroCluster c : dbmc) {
                if (c.isClustered()) continue;
                ++noise;
            }
            System.out.println("microclusters which are not clustered:: " + noise);
            Clustering result = new Clustering(res);
            this.setClusterIDs(result);
            return result;
        }
        return new Clustering();
    }

    private List<CFCluster> Convert2microclusterList(ArrayList<DenseMicroCluster> cluster) {
        Vector<CFCluster> cfCluster = new Vector<CFCluster>();
        for (DenseMicroCluster d : cluster) {
            cfCluster.add(d.getCFCluster());
        }
        return cfCluster;
    }
}

