% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DST_WriteStream.R
\name{DST_WriteStream}
\alias{DST_WriteStream}
\title{Task to Write a Stream to a File or a Connection}
\usage{
DST_WriteStream(file, append = TRUE, ...)
}
\arguments{
\item{file}{A file name or a R connection to be written to.}

\item{append}{Append the data to an existing file.}

\item{...}{further arguments are passed on to \code{\link[=write_stream]{write_stream()}}.}
}
\description{
Writes points from a data stream DSD object to a file or a connection.
}
\examples{
set.seed(1500)

stream <- DSD_Gaussians(k = 3, d = 2)
writer <- DST_WriteStream(file = "data.txt", info = TRUE, header = TRUE)

update(writer, stream, n = 2)
readLines("data.txt")
update(writer, stream, n = 3)
readLines("data.txt")

# clean up
file.remove("data.txt")
}
\seealso{
Other DST: 
\code{\link{DSAggregate}()},
\code{\link{DSClassifier}()},
\code{\link{DSC}()},
\code{\link{DSF_Scale}()},
\code{\link{DSOutlier}()},
\code{\link{DST_Runner}()},
\code{\link{DST}()},
\code{\link{evaluate}},
\code{\link{predict}()},
\code{\link{update}()}
}
\author{
Michael Hahsler
}
\concept{DST}
