% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mostRepresentativeSequences.R
\name{mostRepresentativeSequences}
\alias{mostRepresentativeSequences}
\title{Representative Sequences}
\usage{
mostRepresentativeSequences(x, num.seqs = NULL, model = "raw",
  pairwise.deletion = TRUE)
}
\arguments{
\item{x}{a \code{\link[ape]{DNAbin}} object.}

\item{num.seqs}{number of sequence names to return.}

\item{model}{a character string specifying the evolutionary model to be used. 
See \link{dist.dna} for more information.}

\item{pairwise.deletion}{a logical indicating whether to delete sites 
with missing data. See \link{dist.dna} for more information.}
}
\value{
a vector of the sequence names.
}
\description{
Finds the set of sequences that represent the requested 
  number of clusters.
}
\examples{
library(ape)
data(dolph.seqs)

mostRepresentativeSequences(as.DNAbin(dolph.seqs))

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
