% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dupGenotypes.R
\name{dupGenotypes}
\alias{dupGenotypes}
\title{Duplicate Genotypes}
\usage{
dupGenotypes(g, num.shared = 0.8, num.cores = 1)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{num.shared}{either number of loci or percentage of loci two 
individuals must share to be considered duplicate individuals.}

\item{num.cores}{number of CPU cores to use.}
}
\value{
if no duplicates are present, the result is \code{NULL}, otherwise
  a data.frame with the following columns is returned:
\tabular{ll}{
  \code{ids.1, ids.2} \tab sample ids.\cr
  \code{strata.1, strata.2} \tab sample stratification.\cr
  \code{num.loci.genotyped} \tab number of loci genotyped for both 
    samples.\cr
  \code{num.loci.shared} \tab number of loci shared (all alleles the same) between both samples.\cr
  \code{prop.loci.shared} \tab proportion of loci genotyped for both samples 
    that are shared.\cr
  \code{mismatch.loci} \tab loci where the two samples do not match.\cr
}
}
\description{
Identify duplicate or very similar genotypes.
}
\examples{
data(msats.g)

# identify potential duplicates in Coastal strata
dupes <- dupGenotypes(msats.g[, , "Coastal"])
dupes

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
