% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDgenepop.R
\name{LDgenepop}
\alias{LDgenepop}
\title{Linkage Disequlibrium}
\usage{
LDgenepop(g, show.output = FALSE, delete.files = TRUE,
  label = "linkage.genepop", ...)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{show.output}{logical. Show GENEPOP output on console?}

\item{delete.files}{logical. Delete GENEPOP input and output files when done?}

\item{label}{character string to use to label GENEPOP input and output files.}

\item{...}{other arguments to be passed to \code{\link{genepop}}.}
}
\value{
data.frame of disequilibrium estimates between pairs of individuals
}
\description{
Calculate linkage disequilibrium p-values using GENEPOP.
}
\examples{
\dontrun{
data(msats.g)
msats.ld <- LDgenepop(msats.g)
head(msats.ld)
}

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\seealso{
\link{genepop}
}

