% Generated by roxygen2 (4.0.2): do not edit by hand
\name{allele.freq.format}
\alias{allele.freq.format}
\title{Compiles and Formats Allele Frequencies}
\usage{
allele.freq.format(x, g)
}
\arguments{
\item{x}{data.frame where first column is sample id and second is locus name}

\item{g}{a \code{gtypes} object.}
}
\value{
data.frame of original samples, loci, and formatted alleles and frequencies.
}
\description{
Compiles and Formats Allele Frequencies
}
\examples{
data(dolph.strata)
data(dolph.msats)

msat.merge <- merge(dolph.strata, dolph.msats, by = "ids", all.y = TRUE, sort = FALSE)
msats <- gtypes(msat.merge, id.col = 1, strata.col = 3, locus.col = 5)

# select 10 random ids and loci to form input data.frame
sample.locus.df <- data.frame(
  ids = sample(rownames(msats$genotypes), 10, rep = TRUE),
  loci = sample(attr(msats, "locus.names"), 10, rep = TRUE)
)

allele.freq.format(sample.locus.df, msats)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

