% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratEst_test.R
\name{stratEst.test}
\alias{stratEst.test}
\title{Runs t-tests if model parameters differ from user defined values}
\usage{
stratEst.test(
  model,
  par = c("shares", "probs", "trembles", "coefficients"),
  values = 0,
  alternative = "two.sided",
  digits = 4
)
}
\arguments{
\item{model}{a fitted model of class \code{stratEst.model}.}

\item{par}{a character vector. The class of model parameters to be tested. Default is \code{c("shares","probs","trembles", "coefficients")}.}

\item{values}{a numeric vector. The values the parameter estimates are compared to. Default is zero.}

\item{alternative}{a character string. The alternative hypothesis. Options are \code{"two.sided"}, \code{"greater"} or \code{"less"}. Default is \code{"two.sided"}.}

\item{digits}{an integer. The number of digits of the result.}
}
\value{
A \code{data.frame} with one row for each tested parameter and 6 variables:
\item{estimate}{the parameter estimate.}
\item{diff}{the difference between the estimated parameter and the numeric value.}
\item{std.error}{the standard error of the estimated parameter.}
\item{t.value}{the t statistic.}
\item{res.degrees}{the residual degrees of freedom of the model.}
\item{p.value}{the p value of the t statistic.}
}
\description{
Runs t-tests if model parameters differ from user defined values
}
\details{
The test function of the package.
}
\examples{
## Test if the choice probabilities of a mixed strategy for rock-paper-scissors.
## The rock-paper-scissors data is from Wang, Xu, and Zhou (2014).
model.mixed <- stratEst.model(data = data.WXZ2014, strategies = strategies.RPS["mixed"])
t.probs <- stratEst.test(model = model.mixed, par = "probs", values = 1/3)
print(t.probs)
}
\references{
Wang Z, Xu B, Zhou HJ (2014). "Social Cycling and Conditional Responses in the Rock-Paper-Scissors Game." \emph{Scientific Reports}, 4(1), 2045-2322.
}
