% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplify.R
\name{samplify}
\alias{samplify}
\title{Created a resampled tibble}
\usage{
samplify(data, times, size, ..., replace = FALSE, key = ".sample")
}
\arguments{
\item{data}{A tbl.}

\item{times}{A single integer specifying the number of resamples.
If the \code{tibble} is grouped, this is the number of resamples per group.}

\item{size}{A single integer specifying the size of each resample. For a
grouped data frame, this is also allowed to be an integer vector with size
equal to the number of groups in \code{data}. This can be helpful when sampling
without replacement when the number of rows per group is very different.}

\item{...}{Not used.}

\item{replace}{Whether or not to sample with replacement.}

\item{key}{A single character specifying the name of the virtual group
that is added.}
}
\value{
A \code{resampled_df} with an extra group specified by the \code{key}.
}
\description{
\code{samplify()} creates a resampled tibble with \emph{virtual groups}.
}
\details{
The following functions have special / interesting behavior when used with
a \code{resampled_df}:
\itemize{
\item \code{\link[dplyr:collect]{dplyr::collect()}}
\item \code{\link[dplyr:summarise]{dplyr::summarise()}}
\item \code{\link[dplyr:do]{dplyr::do()}}
\item \code{\link[dplyr:group_map]{dplyr::group_map()}}
\item \code{\link[dplyr:group_walk]{dplyr::group_walk()}}
\item \code{\link[dplyr:group_nest]{dplyr::group_nest()}}
\item \code{\link[dplyr:group_split]{dplyr::group_split()}}
}
}
\examples{
library(dplyr)
library(broom)

samplify(iris, times = 3, size = 20)

iris \%>\%
  samplify(times = 3, size = 20) \%>\%
  summarise(per_strap_mean = mean(Petal.Width))

iris \%>\%
  group_by(Species) \%>\%
  samplify(times = 3, size = 20) \%>\%
  summarise(per_strap_species_mean = mean(Petal.Width))

# Alter the name of the group with `key`
# Materialize them with collect()
samps <- samplify(iris, times = 3, size = 5, key = ".samps")
collect(samps)

collect(samps, id = ".id", original_id = ".orig_id")

#----------------------------------------------------------------------------

# Be careful not to specify a `size` larger
# than one of your groups! This will throw an error.

iris_group_sizes_of_50_and_5 <- iris[1:55,] \%>\%
  group_by(Species) \%>\%
  group_trim()

count(iris_group_sizes_of_50_and_5, Species)

# size = 10 > min_group_size = 5
\dontrun{
iris_group_sizes_of_50_and_5 \%>\%
  samplify(times = 2, size = 10)
}

# Instead, pass a vector of sizes to `samplify()` if this
# structure is absolutely required for your use case.

# size of 10 for the first group
# size of 5 for the second group
# total number of rows is 10 * 2 + 5 * 2 = 30
iris_group_sizes_of_50_and_5 \%>\%
  samplify(times = 2, size = c(10, 5)) \%>\%
  collect()

}
\seealso{
\code{\link[=collect.resampled_df]{collect.resampled_df()}}

Other virtual samplers: \code{\link{bootstrapify}}
}
\concept{virtual samplers}
