% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HP.mod.R
\name{dens.prior}
\alias{dens.prior}
\title{Density of priors.}
\usage{
dens.prior(x, pri.lo = c(0, 0, 0, 0, 0, 0, 15, 0, 0), pri.hi = c(0.15, 1, 1,
  0.5, 0.25, 15, 55, 0.1, 1.25))
}
\arguments{
\item{x}{A 1 * 9 vector or n * 9 matrix containing values for the eight Heligman-Pollard Parameters.}

\item{pri.lo}{A vector giving the lower bounds of the uniform priors.}

\item{pri.hi}{A vector giving the upper bounds of the uniform priors.}
}
\value{
A scalar describing the density of the prior distribution.
}
\description{
This function calculates the density of the prior distribution for the 9 parameters of the adapted Heligman-Pollard model. The density is calculated using a uniform distribution.
}
\references{
Sharrow, D.J., Clark, S.J., Collinson, M.A., Kahn, K. and Tollman, S.M. (2013). The Age Pattern of Increases in Mortality Affected by HIV: Bayesian Fit of the Heligman-Pollard Model to Data from the Agincourt HDSS Field Site in Rural Northeast South Africa. Demogr. Res. 29, 1039–1096.
}
\keyword{Heligman-Pollard}
\keyword{bycatch}
\keyword{density}
\keyword{mortality}
\keyword{priors}
