% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm_gen.R
\name{spm_gen}
\alias{spm_gen}
\title{Continuous multi-dimensional optimization for Genetic SPM (multidimensional GenSPM)}
\usage{
spm_gen(dat, a = -0.05, f1 = 80, Q = 2e-08, f = 80, b = 5,
  mu0 = 2e-05, theta = 0.08, p = 0.25, stopifbound = FALSE,
  algorithm = "NLOPT_LN_COBYLA", lb = NULL, ub = NULL, maxeval = 500,
  verbose = FALSE, pinv.tol = 0.01)
}
\arguments{
\item{dat}{A data table.}

\item{a}{A starting value of the rate of adaptive response to any deviation of Y from f1(t).}

\item{f1}{A starting value of the average age trajectories of the variables which process is forced to follow.}

\item{Q}{Starting values of the quadratic hazard term.}

\item{f}{A starting value of the "optimal" value of variable which corresponds to the minimum of hazard rate at a respective time.}

\item{b}{A starting value of a diffusion coefficient representing a strength of the random disturbance from Wiener Process.}

\item{mu0}{A starting value of the baseline hazard.}

\item{theta}{A starting value of the parameter theta (axe displacement of Gompertz function).}

\item{p}{A proportion of carriers and non-carriers in a population (default p=0.25).}

\item{stopifbound}{Estimation stops if at least one parameter achieves lower or upper boundaries.}

\item{algorithm}{An optimization algorithm used, can be one of those provided by \code{nloptr}. 
#'Check the NLopt website for a description of
the algorithms. Default: NLOPT_LN_COBYLA}

\item{lb}{Lower bound of parameters under estimation.}

\item{ub}{Upper bound of parameters under estimation.}

\item{maxeval}{Maximum number of iterations of the algorithm for \code{nloptr} optimization. 
The program stops when the number of function evaluations exceeds maxeval. Default: 500.}

\item{verbose}{An indicator of verbosing output.}

\item{pinv.tol}{A tolerance value for pseudo-inverse of matrix gamma (see Yashin, A.I. et al (2007). Stochastic model for analysis of longitudinal data on aging 
and mortality. Mathematical Biosciences, 208(2), 538-551.<DOI:10.1016/j.mbs.2006.11.006>.)}
}
\value{
A set of estimated parameters a, f1, Q, f, b, mu0, theta and
additional variable \code{limit} which indicates if any parameter 
achieved lower or upper boundary conditions (FALSE by default).
}
\description{
Continuous multi-dimensional optimization for Genetic SPM (multidimensional GenSPM)
}
\details{
\code{spm_continuous} runs much slower that discrete but more precise and can handle time intervals with different lengths.
}
\examples{
library(stpm)
#Reading the data:
data <- simdata_gen(N=2)
head(data)
#Parameters estimation:
pars <- spm_gen(dat=data,a=-0.05, f1=80, 
					 Q=2e-8, f=80, b=5, mu0=2e-5, theta=0.08)
pars

}
\references{
Arbeev, K.G. et al (2009). Genetic model for longitudinal studies of aging, health, and longevity

Yashin, A.I. et al (2007). Stochastic model for analysis of longitudinal data on aging 
and mortality. Mathematical Biosciences, 208(2), 538-551.<DOI:10.1016/j.mbs.2006.11.006>.
}

