% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toptail.R
\name{geo_toptail}
\alias{geo_toptail}
\alias{toptail}
\title{Clip the first and last n metres of SpatialLines}
\usage{
geo_toptail(l, toptail_dist, ...)
}
\arguments{
\item{l}{A SpatialLines object}

\item{toptail_dist}{The distance (in metres) to top and tail the line by.
Can either be a single value or a vector of the same length as the
SpatialLines object.}

\item{...}{Arguments passed to rgeos::gBuffer()}
}
\description{
Takes lines and removes the start and end point, to a distance determined
by the user.
}
\details{
Note: \code{\link[=toptailgs]{toptailgs()}} is around 10 times faster, but only works
on data with geographic CRS's due to its reliance on the geosphere
package.
}
\examples{
l <- routes_fast_sf[2:4, ]
l_top_tail <- geo_toptail(l, 300)
l_top_tail
plot(sf::st_geometry(l_top_tail))
plot(sf::st_geometry(geo_toptail(l, 600)), lwd = 9, add = TRUE)
# dont test due to issues with sp classes on some set-ups
# l <- routes_fast[2:4, ]
# l_toptail <- geo_toptail(l, toptail_dist = 300)
# plot(l)
# plot(l_toptail, col = "red", add = TRUE, lwd = 3)
# plot(cents, col = "blue", add = TRUE, pch = 15)
# # Note the behaviour when the buffer size removes lines
# r_toptail <- geo_toptail(l, toptail_dist = 900)
# nrow(r_toptail)
# plot(r_toptail, lwd = 9, add = TRUE) # short route removed
}
\seealso{
Other lines: 
\code{\link{angle_diff}()},
\code{\link{is_linepoint}()},
\code{\link{line2df}()},
\code{\link{line2points}()},
\code{\link{line_bearing}()},
\code{\link{line_match}()},
\code{\link{line_midpoint}()},
\code{\link{line_sample}()},
\code{\link{line_segment}()},
\code{\link{line_via}()},
\code{\link{mats2line}()},
\code{\link{n_sample_length}()},
\code{\link{n_vertices}()},
\code{\link{onewaygeo}()},
\code{\link{points2line}()},
\code{\link{toptail_buff}()},
\code{\link{toptailgs}()},
\code{\link{update_line_geometry}()}
}
\concept{lines}
