% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialLinesNetwork.R
\name{sum_network_links}
\alias{sum_network_links}
\title{Summarise links from shortest paths data}
\usage{
sum_network_links(sln, routedata)
}
\arguments{
\item{sln}{The SpatialLinesNetwork or sfNetwork to use.}

\item{routedata}{A dataframe where the first column contains the Node ID(s)
of the start of the routes, the second column indicates the Node ID(s) of
the end of the routes, and any additional columns are summarised by link.
If there are no additional colums, then overlapping routes are counted.}
}
\description{
Summarise links from shortest paths data
}
\section{Details}{

Find the shortest path on the network between specified nodes and returns
a SpatialLinesDataFrame or sf containing the path(s) and summary statistics
of each one.
}

\examples{
data(routes_fast)
rnet <- overline(routes_fast, attrib = "length")
SLN <- SpatialLinesNetwork(rnet)
weightfield(SLN) # field used to determine shortest path
shortpath <- sum_network_links(
  SLN,
  data.frame(
    start = rep(c(1, 2, 3, 4, 5), each = 4),
    end = rep(c(50, 51, 52, 33), times = 5)
  )
)
plot(shortpath, lwd = shortpath$count)
}
