% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routes.R
\name{route_graphhopper}
\alias{route_graphhopper}
\title{Plan a route with the graphhopper routing engine}
\usage{
route_graphhopper(from, to, vehicle = "bike", silent = TRUE, pat = NULL,
  base_url = "https://graphhopper.com")
}
\arguments{
\item{from}{Text string or coordinates (a numeric vector of
\code{length = 2} representing latitude and longitude) representing a point
on Earth.}

\item{to}{Text string or coordinates (a numeric vector of
\code{length = 2} representing latitude and longitude) representing a point
on Earth. This represents the destination of the trip.}

\item{vehicle}{A text string representing the vehicle. Can be bike, bike2, car
or foot.}

\item{silent}{Logical (default is FALSE). TRUE hides request sent.}

\item{pat}{The API key used. By default this is set to NULL and
this is usually aquired automatically through a helper, api_pat().}

\item{base_url}{The base url from which to construct API requests
(with default set to main server)}
}
\description{
Provides an R interface to the graphhopper routing engine,
an open source route planning service.
}
\details{
The function returns a SpatialLinesDataFrame object.
See \url{https://github.com/graphhopper} for more information.



To test graphopper is working for you, try something like this, but with
your own API key:
To use this function you will need to obtain an API key from
\url{https://graphhopper.com/#directions-api}.
It is assumed that you have set your api key as a system environment
for security reasons (so you avoid typing the API key in your code).
Do this by adding the following to your .Renviron file (see \code{?.Renviron}
or the 'api-packages' vignette at \url{https://cran.r-project.org/package=httr}
for more on this):

\code{GRAPHHOPPER='FALSE-Key-eccbf612-214e-437d-8b73-06bdf9e6877d'}.

(Note: key not real, use your own key.)

\code{obj <- jsonlite::fromJSON(url)}

Where \code{url} is an example api request from
 \url{https://github.com/graphhopper/directions-api/blob/master/routing.md}.
}
\examples{
\dontrun{
r <- route_graphhopper(from = "Leeds", to = "Dublin", vehicle = "bike")
r@data
plot(r)
r <- route_graphhopper("New York", "Washington", vehicle = "foot")
plot(r)
}
}
\seealso{
route_cyclestreet
}
