% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{cents}
\alias{cents}
\title{SpatialPointsDataFrame of home locations for flow analysis.}
\format{A SpatialPoints with 8 rows and 5 variables}
\usage{
data(cents)
}
\description{
These points represent population-weighted centroids of Medium Super Output Area (MSOA) zones within a 1 mile radius of of my home when I was writing this package.
}
\details{
\itemize{
  \item geo_code. the official code of the zone
  \item MSOA11NM. name zone name
  \item percent_fem. the percent female
  \item avslope. average gradient of the zone
}

Cents was generated from the data repository pct-data: https://github.com/npct/pct-data. This data was accessed from within the pct repo: https://github.com/npct/pct, using the following code:
}
\examples{
\dontrun{
cents <- rgdal::readOGR(dsn = "/home/robin/npct/pct-bigdata/cents.geojson", layer = "OGRGeoJSON")
# library(geojsonio) # load with the ropensci package geojsonio if rgdal fails
# cents <- geojsonio::geojson_read(x = "~/repos/pct/pct-data/national/cents.geojson")
crs <- CRS("+init=epsg:4326")
crsuk <- CRS("+init=epsg:27700")
cents <- sp::spTransform(x = cents, CRSobj = crsuk)
home <- rev(RgoogleMaps::getGeoCode("LS7 3HB"))
home <- sp::SpatialPoints(matrix(home, ncol = 2), proj4string = crs)
home <- sp::spTransform(x = home, CRSobj = crsuk)
buf <- rgeos::gBuffer(home, width = 2000)
# Check it saved the points OK
cents <- cents[buf,]
plot(buf)
points(cents)
cents <- sp::spTransform(x = cents, CRSobj = crs)
cents$geo_code <- as.character(cents$geo_code)
library(devtools)
# use_data(cents, overwrite = TRUE)
}

}
\keyword{datasets}
