% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structurednessindices.R
\name{c_mine}
\alias{c_mine}
\title{wrapper for getting the mine coefficients}
\usage{
c_mine(confs, master = NULL, alpha = 0.6, C = 15, var.thr = 1e-05, zeta = NULL)
}
\arguments{
\item{confs}{a numeric matrix or data frame with two columns}

\item{master}{the master column}

\item{alpha}{an optional number of cells allowed in the X-by-Y search-grid. Default value is 0.6}

\item{C}{an optional number determining the starting point of the X-by-Y search-grid. When trying to partition the x-axis into X columns, the algorithm will start with at most C X clumps. Default value is 15.}

\item{var.thr}{minimum value allowed for the variance of the input variables, since mine can not be computed in case of variance close to 0. Default value is 1e-5.}

\item{zeta}{integer in [0,1] (?).  If NULL (default) it is set to 1-MIC. It can be set to zero for noiseless functions, but the default choice is the most appropriate parametrization for general cases (as stated in Reshef et al. SOM; they call it epsilon in the paper). It provides robustness.}
}
\description{
wrapper for getting the mine coefficients
}
