% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structurednessindices.R
\name{c_dependence}
\alias{c_dependence}
\title{c-dependence
calculates c-dependence as the aggregated distance correlation of each pair if nonidentical columns}
\usage{
c_dependence(confs, aggr = max, index = 1)
}
\arguments{
\item{confs}{a numeric matrix or data frame}

\item{aggr}{the aggregation function for configurations of more than two dimensions. Defaults to max.}

\item{index}{exponent on Euclidean distance, in (0,2]}
}
\value{
a numeric value; dependence (aggregated distance correlation)
}
\description{
c-dependence
calculates c-dependence as the aggregated distance correlation of each pair if nonidentical columns
}
\examples{
x<-1:10
y<-2+3*x+rnorm(10)
confs<-cbind(x,y)
c_dependence(confs,1.5)
}
