% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizations.R
\name{tgpoptim}
\alias{tgpoptim}
\title{Bayesian Optimization by a (treed) Bayesian Gaussian Process Prior (with jumps to linear models) surrogate model
Essentially a wrapper for the functionality in tgp that has the same slots as optim with defaults for STOPS models.}
\usage{
tgpoptim(
  x,
  fun,
  ...,
  initpoints = 10,
  lower,
  upper,
  acc = 1e-08,
  itmax = 10,
  verbose = 0,
  model = "bgp"
)
}
\arguments{
\item{x}{optional starting values}

\item{fun}{function to minimize}

\item{...}{additional arguments to be passed to the function to be optimized}

\item{initpoints}{the number of points to sample initially to fit the surrogate model}

\item{lower}{The lower contraints of the search region}

\item{upper}{The upper contraints of the search region}

\item{acc}{if the numerical accuracy of two successive target function values is below this, stop the optimization; defaults to 1e-8}

\item{itmax}{maximum number of iterations}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is extremely verbose}

\item{model}{which surrogate model class to use (currently uses defaults only, will extend this to tweak the model)}
}
\value{
A list with the components (for compatiility with \code{\link{optim}})
\itemize{
     \item par The position of the optimum in the search space (parameters that minimize the function; argmin fun). 
     \item value The value of the objective function at the optimum (min fun). Note we do not use the last value in the candidate list but the best candidate (which can but need not coincide). 
     \item svalue The value of the surrogate objective function at the optimal parameters
     \item counts The number of iterations performed at convergence with entries fnction for the number of iterations and gradient which is always NA at the moment
     \item convergence 0 successful completion by the accd or acc criterion, 1 indicate iteration limit was reached, 99 is a problem 
     \item message is NULL (only for compatibility or future use)
     \item history the improvement history
     \item tgpout the output of the tgp model    
}
}
\description{
Bayesian Optimization by a (treed) Bayesian Gaussian Process Prior (with jumps to linear models) surrogate model
Essentially a wrapper for the functionality in tgp that has the same slots as optim with defaults for STOPS models.
}
\examples{
\donttest{
fbana <- function(x) {
x1 <- x[1]
x2 <- x[2]
100 * (x2 - x1 * x1)^2 + (1 - x1)^2
}
res1<-tgpoptim(c(-1.2,1),fbana,lower=c(-5,-5),upper=c(5,5),acc=1e-16,itmax=20)
res1

fwild <- function (x) 10*sin(0.3*x)*sin(1.3*x^2) + 0.00001*x^4 + 0.2*x+80
plot(fwild, -50, 50, n = 1000, main = "Bayesian GP Optimization minimizing 'wild function'")
set.seed(210485)
res2<-tgpoptim(50, fwild,lower=-50,upper=50,acc=1e-16,itmax=20,model="btgpllm")
points(res2$par,res2$value,col="red",pch=19)
res2
}
}
