% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stops-package.R, R/stops.R
\docType{package}
\name{stops}
\alias{stops}
\title{stops: structure optimized proximity scaling}
\usage{
stops(
  dis,
  loss = c("strain", "stress", "smacofSym", "powerstress", "powermds", "powerelastic",
    "powerstrain", "elastic", "sammon", "sammon2", "smacofSphere", "powersammon",
    "rstress", "sstress", "isomap", "isomapeps", "bcstress", "lmds", "apstress",
    "rpowerstress"),
  theta = 1,
  structures = c("cclusteredness", "clinearity", "cdependence", "cmanifoldness",
    "cassociation", "cnonmonotonicity", "cfunctionality", "ccomplexity", "cfaithfulness",
    "cregularity", "chierarchy", "cconvexity", "cstriatedness", "coutlying",
    "cskinniness", "csparsity", "cstringiness", "cclumpiness", "cinequality"),
  ndim = 2,
  weightmat = NULL,
  init = NULL,
  stressweight = 1,
  strucweight,
  strucpars,
  optimmethod = c("SANN", "ALJ", "pso", "Kriging", "tgp", "DIRECT", "stogo", "cobyla",
    "crs2lm", "isres", "mlsl", "neldermead", "sbplx", "hjk", "cmaes"),
  lower,
  upper,
  verbose = 0,
  type = c("additive", "multiplicative"),
  initpoints = 10,
  itmax = 50,
  itmaxps = 10000,
  model,
  control,
  ...
)
}
\arguments{
\item{dis}{numeric matrix or dist object of a matrix of proximities}

\item{loss}{which loss function to be used for fitting, defaults to stress.}

\item{theta}{hyperparameter vector starting values for the transformation functions. If the length is smaller than the number of hyperparameters for the MDS version the vector gets recycled (see the corresponding stop_XXX function or the vignette for how theta must look like exactly for each loss). If larger than the number of hyperparameters for the MDS method, an error is thrown. If completely missing theta is set to 1 and recycled.}

\item{structures}{character vector of which c-structuredness indices should be considered; if missing no structure is considered.}

\item{ndim}{number of dimensions of the target space}

\item{weightmat}{(optional) a matrix of nonnegative weights; defaults to 1 for all off diagonals}

\item{init}{(optional) initial configuration}

\item{stressweight}{weight to be used for the fit measure; defaults to 1}

\item{strucweight}{vector of weights to be used for the c-structuredness indices (in the same order as in structures); defaults to -1/length(structures) for each index}

\item{strucpars}{(possibly named with the structure). Metaparameters for the structuredness indices (gamma in the article). It's safest for it be a list of lists with the named arguments for the structuredness indices and the order of the lists must be like the order of structures. So something like this \code{list(list(par1Struc1=par1Struc1,par2Struc1=par2Struc1),list(par1Struc2=par1Struc2,par2Struc2=par2Struc2),...)} where parYStrucX are the named arguments for the metaparameter Y of the structure X the list elements corresponds to. For a structure without parameters, set NULL. Parameters in different list elements parYStrucX can have the same name. For example, say we want to use cclusteredness with metaparameters epsilon=10 and k=4 (and the default for the other parameters), cdependence with no metaparameters and cfaithfulness with metaparameter k=7 one would \code{list(list(epsilon=10,k=4),list(NULL),list(dis=obdiss,k=6))}  for structures vector ("cclusteredness","cdependence","cfaithfulness"). The parameter lists must be in the same ordering as the indices in structures. If missing it is set to NULL and defaults are used. It is also possible to supply a structure's metaparameters as a list of vectors with named elements if the metaparameters are scalars, so like \code{list(c(par1Struc1=parStruc1,par2Struc1=par1Struc1,...),c(par1Struc2=par1Struc2,par2Struc2=par2Struc2,...))}. That can have unintended consequences if the metaparameter is a vector or matrix.}

\item{optimmethod}{What solver to use. Currently supported are Bayesian optimization with Gaussian Process priors and Kriging ("Kriging"), Bayesian optimization with treed Gaussian processes with jump to linear models ("tgp"), Adaptive LJ Search ("ALJ"), Particle Swarm optimization ("pso"), simulated annealing ("SANN"), "DIRECT", Stochastic Global Optimization ("stogo"), COBYLA ("cobyla"), Controlled Random Search 2 with local mutation ("crs2lm"), Improved Stochastic Ranking Evolution Strategy ("isres"), Multi-Level Single-Linkage ("mlsl"), Nelder-Mead ("neldermead"), Subplex ("sbplx"), Hooke-Jeeves Pattern Search ("hjk"), CMA-ES ("cmaes"). Defaults to "ALJ" version. tgp, ALJ, Kriging and pso usually work well for relatively low values of itmax.}

\item{lower}{The lower contraints of the search region. Needs to be a numeric vector of the same length as the parameter vector theta.}

\item{upper}{The upper contraints of the search region. Needs to be a numeric vector of the same length as the parameter vector theta.}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is very verbose.}

\item{type}{which aggregation for the multi objective target function? Either 'additive' (default) or 'multiplicative'}

\item{initpoints}{number of initial points to fit the surrogate model for Bayesian optimization; default is 10.}

\item{itmax}{maximum number of iterations of the outer optimization (for theta) or number of steps of Bayesian optimization; default is 50. We recommend a higher number for ALJ (around 150). Note that due to the inner workings of some solvers, this may or may not correspond to the actual number of function evaluations performed (or PS models fitted). E.g., with tgp the actual number of function evaluation of the PS method is between itmax and 6*itmax as tgp samples 1-6 candidates from the posterior and uses the best candidate. For pso it is the number of particles s times itmax. For cmaes it is usually a bit higher than itmax. This currently may get overruled by a control argument if it is used (and then set to either ewhat is supplie dby control or to the default of the method).}

\item{itmaxps}{maximum number of iterations of the inner optimization (to obtain the PS configuration)}

\item{model}{a character specifying the surrogate model to use. For Kriging it specifies the covariance kernel for the GP prior; see \code{\link{covTensorProduct-class}} defaults to "powerexp". For tgp it specifies the non stationary process used see \code{\link{bgp}}, defaults to "btgpllm"}

\item{control}{a control argument passed to the outer optimization procedure. Will override any other control arguents passed, especially verbose and itmax. For the efect of control, see the functions pomp::sannbox for SANN and pso::psoptim for pso, cmaes::cma_es for cmaes, dfoptim::hjkb for hjk and the nloptr docs for the algorithms DIRECT, stogo, cobyla, crs2lm, isres, mlsl, neldermead, sbplx.}

\item{...}{additional arguments passed to the outer optimization procedures (not fully tested).}
}
\value{
A list with the components
        \itemize{
        \item stoploss: the stoploss value
        \item optim: the object returned from the optimization procedure
        \item stressweight: the stressweight
        \item strucweight: the vector of structure weights
        \item call: the call
        \item optimmethod: The solver selected
        \item losstype: The PS badness-of-fit function
        \item nobj: the number of objects in the configuration
        \item type: The type of stoploss scalacrisation (additive or multiplicative)
        \item fit: The fitted PS object (most importantly $fit$conf the fitted configuration) 
}
}
\description{
A package for "structure optimized proximity scaling" (STOPS), a collection of methods that fit nonlinear distance transformations in multidimensional scaling (MDS) and trade-off the fit with structure considerations to find optimal parameters or optimal configurations. The package contains various functions, wrappers, methods and classes for fitting, plotting and displaying different MDS models in a STOPS framework like Torgerson scaling, SMACOF, Sammon mapping, elastic scaling, symmetric SMACOF, spherical SMACOF, sstress, rstress, powermds, power elastic scaling, power sammon mapping, power stress, Isomap, approximate power stress, restricted power stress. All of these models can also be fit as MDS variants (i.e., no structuredness). The package further contains functions for optimization (Adaptive Luus-Jaakola and for Bayesian optimization with treed Gaussian process with jump to linear models) and functions for various structuredness indices

This allows to fit STOPS models as described in Rusch, Mair, Hornik (2023).
}
\details{
The stops package provides five categories of important functions:

Models & Algorithms:
\itemize{
\item stops() ... which fits STOPS models as described in Rusch et al. (2023). By setting cordweight or strucweight to zero they can also be used to fit metric MDS for many different models, see below.  
\item powerStressMin()... a workhorse for fitting many stresses, including s-stress, r-stress (De Leeuw, 2014), Sammon mapping with power transformations (powersammon), elastic scaling with power transformation (powerelastic), power stress. They can most conveniently be accessed via the stops functions and setting stressweight=1 and cordweight or strucweight=0 or by the dedicated functions starting with stop_foo where foo is the method and setting stressweight=1 and strucweight=0. It uses the nested majorization algorithm for r-stress of De Leeuw(2014).
\item bcStressMin()... a workhorse for fitting Box-Cox stress (Chen & Buja, 2013).
\item lmds()... a workhorse for the local MDS of Chen & Buja (2008).
}


Structuredness Indices:
Various c-structuredness as c_foo(), where foo is the name of the structuredness.  See Rusch et al. (2023). 

Optimization functions:
\itemize{
\item ljoptim() ... An (adaptive) version of the Luus-Jakola random search
}
Wrappers and convenience functions:
\itemize{
\item conf_adjust(): procrustes adjustment of configurations 
\item cmdscale(), sammon(): wrappers that return S3 objects
\item stop_smacofSym(), stop_sammon(), stop_cmdscale(), stop_rstress(), stop_powerstress(),stop_smacofSphere(), stop_sammon2(), stop_elastic(), stop_sstress(), stop_powerelastic(), stop_powersammon(),  stop_powermds(), stop_isomap(), stop_isomapeps(), stop_bcstress(), stop_lmds(), stop_apstress(),stops_rpowerstress(): stop versions of these MDS models.
\item stoploss() ... a function to calculate stoploss (Rusch et al., 2023)
}

Methods: 
For most of the objects returned by the high-level functions S3 classes and methods for standard generics were implemented, including print, summary, plot, plot3d, plot3dstatic.   

References:
\itemize{
\item Rusch, T., Mair, P., & Hornik, K. (2023). Structure-based hyperparameter selection with Bayesian optimization in multidimensional scaling. Statistics & Computing, 33, [28]. https://doi.org/10.1007/s11222-022-10197-w
}

Authors: Thomas Rusch, Lisha Chen, Jan de Leeuw, Patrick Mair, Kurt Hornik

Maintainer: Thomas Rusch

The combination of c-structurednes indices and stress uses the stress.m values, which are the explictly normalized stresses. Reported however is the stress-1 value which is sqrt(stress.m).
}
\examples{
data(kinshipdelta,package="smacof")

strucpars<-list(list(epsilon=10,minpts=2,scale=3),list(NULL))
dissm<-as.matrix(kinshipdelta)

#STOPS with strain
resstrain<-stops(dissm,loss="strain",theta=1,structures=c("cclusteredness","cdependence"),
strucpars=strucpars,optimmethod="ALJ",lower=0,upper=10,itmax=10)
resstrain
summary(resstrain)
plot(resstrain)

\donttest{
#STOPS with stress
strucpars<-list(list(epsilon=10,minpts=2,scale=3),NULL) 
resstress<-stops(dissm,loss="stress",
structures=c("cclusteredness","cdependence"),
strucpars=strucpars,optimmethod="ALJ",lower=0,upper=10)
resstress
summary(resstress)
plot(resstress)
plot(resstress,"Shepard")

#STOPS with powerstress
respstress<-stops(dissm,loss="powerstress",
structures=c("cclusteredness","cdependence"),
strucpars=strucpars,weightmat=dissm,
itmaxps=1000,optimmethod="ALJ",lower=c(0,0,1),upper=c(10,10,10))
respstress
summary(respstress)
plot(respstress)

#STOPS with bcstress
resbcstress<-stops(dissm,loss="bcstress",
structures=c("cclusteredness","cdependence"),
strucpars=strucpars,optimmethod="ALJ",lower=c(0,1,0),upper=c(10,10,10))
resbcstress
summary(resbcstress)
plot(resbcstress)

#STOPS with lmds
reslmds<-stops(dissm,loss="lmds",
structures=c("cclusteredness","clinearity"),
strucpars=strucpars,optimmethod="ALJ",lower=c(2,0),upper=c(10,2))
reslmds
summary(reslmds)
plot(reslmds)

#STOPS with Isomap (the epsilon version)
resiso<-stops(dissm,loss="isomapeps",
structures=c("cclusteredness","clinearity"),
strucpars=strucpars,optimmethod="ALJ",lower=70,upper=120)
resiso
summary(resiso)
plot(resiso)
}

data(kinshipdelta,package="smacof")
strucpar<-list(NULL,NULL) #parameters for indices
res1<-stops(kinshipdelta,loss="stress",
structures=c("cclumpiness","cassociation"),strucpars=strucpar,
lower=0,upper=10,itmax=10)
res1

\donttest{
data(BankingCrisesDistances)
strucpar<-list(c(epsilon=10,minpts=2),NULL) #parameters for indices
res1<-stops(BankingCrisesDistances[,1:69],loss="stress",verbose=0,
structures=c("cclusteredness","clinearity"),strucpars=strucpar,
lower=0,upper=10)
res1

strucpar<-list(list(alpha=0.6,C=15,var.thr=1e-5,zeta=NULL),
list(alpha=0.6,C=15,var.thr=1e-5,zeta=NULL))
res1<-stops(BankingCrisesDistances[,1:69],loss="stress",verbose=0,
structures=c("cfunctionality","ccomplexity"),strucpars=strucpar,
lower=0,upper=10)
res1
}

}
\keyword{clustering}
\keyword{multivariate}
