% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerstress.R
\name{apStressMin}
\alias{apStressMin}
\title{Approximate Power Stress SMACOF}
\usage{
apStressMin(
  delta,
  tau = 1,
  ups = 1,
  weightmat = 1 - diag(nrow(delta)),
  init = NULL,
  ndim = 2,
  eps = 1e-06,
  itmax = 1000,
  verbose = FALSE
)
}
\arguments{
\item{delta}{dist object or a symmetric, numeric data.frame or matrix of distances}

\item{tau}{the power of the transformation of the proximities; defaults to 1}

\item{ups}{the power of the transformation for weightmat; defaults to 1}

\item{weightmat}{a square, symmetric matrix of finite weights (same dimensions as delta)}

\item{init}{starting configuration}

\item{ndim}{dimension of the configuration; defaults to 2}

\item{eps}{numeric accuracy of the iteration}

\item{itmax}{maximum number of iterations}

\item{verbose}{should iteration output be printed; if TRUE then yes}
}
\value{
an object of class 'smacofP' (inheriting from 'smacofB', see \code{\link{smacofSym}}). It is a list with the components
\itemize{
\item delta: Observed dissimilarities, not normalized
\item obsdiss: Observed transformed dissimilarities
\item dhats: Observed transformed dissimilarities, normalized 
\item confdist: Configuration dissimilarities, NOT normalized 
\item conf: Matrix of fitted configuration, NOT normalized
\item stress: Default stress  (stress 1; sqrt of explicitly normalized stress)
\item spp: Stress per point (based on stress.en) 
\item ndim: Number of dimensions
\item model: Name of MDS model
\item niter: Number of iterations
\item nobj: Number of objects
\item type: Type of MDS model
\item weightmat: weighting matrix
\item pars: hyperparameter vector theta
}
and some additional components
\itemize{
\item stress.m: default stress for the COPS and STOP defaults to the explicitly normalized stress on the normalized, transformed dissimilarities. The square of stress-1 in stress. 
\item deltaorig: observed, untransformed dissimilarities
\item tau: tau parameter
\item ups: upsilon parameter 
}
}
\description{
Minimize approximate power stress by minimization-majorization.
}
\examples{
dis<-smacof::kinshipdelta
res<-apStressMin(as.matrix(dis),tau=2,ups=0.7)
res
summary(res)
plot(res)

}
\seealso{
\code{\link{smacofSym}}
}
\author{
Thomas Rusch
}
