% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.stlpm.R
\name{plot.stlpm}
\alias{plot.stlpm}
\title{Plot a \code{stlpm} object}
\usage{
\method{plot}{stlpm}(x, ...)
}
\arguments{
\item{x}{An object of class \code{stpm}}

\item{...}{additional unused argument}
}
\description{
This function plots the covariate stored in the stcov object given in input,
in a three panel plot representing the 3Dplot of the coordinates, and the
mark values.
}
\examples{

set.seed(2)
df <- data.frame(x = runif(100, 0, 0.8), y = runif(100, 0, 0.8), t = runif(100), m = rpois(100, 15))

stlpm1 <- stpm(df, L = chicagonet)

plot(stlpm1)


}
\seealso{
\link{stppm}
}
\author{
Nicoletta D'Angelo
}
