% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdd.R
\name{mdd}
\alias{mdd}
\title{Maximum Drawdown}
\usage{
mdd(prices = NULL, highs = NULL, lows = NULL, gains = NULL,
  indices = FALSE)
}
\arguments{
\item{prices}{Numeric matrix with 1 column of prices for each investment (can 
be a vector if there is only one).}

\item{highs}{Numeric vector of daily high prices.}

\item{lows}{Numeric vector of daily low prices.}

\item{gains}{Numeric matrix with 1 column of gains for each investment (can 
be a vector if there is only one).}

\item{indices}{Logical value for whether to include indices for when the 
maximum drawdown occurred.}
}
\value{
Numeric value, vector, or matrix depending on \code{indices} and whether 
there is 1 fund or several.
}
\description{
Calculates maximum drawdown from vector of closing prices, highs and lows, or 
gains.
}
\examples{
\dontrun{
# Simulate minute-to-minute stock gains over a 2-year period
set.seed(123)
stock.gains <- rnorm(6.5 * 60 * 252 * 2, 0.000005, 0.001)

# Convert to stock prices assuming an initial price of $9.50 per share
stock.prices <- gains_prices(gains = stock.gains, initial = 9.50)

# Plot minute-to-minute stock prices (200k data point, may be slow)
plot(stock.prices)

# Maximum drawdown based on stock prices
mdd(prices = stock.prices)

# Same answer using gains rather than prices
mdd(gains = stock.gains)
}


}
