% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gains_prices.R
\name{gains_prices}
\alias{gains_prices}
\title{Convert Gains to Prices}
\usage{
gains_prices(gains, initial = 10000)
}
\arguments{
\item{gains}{Numeric matrix with 1 column of gains for each investment (can 
be a vector if there is only one).}

\item{initial}{Numeric value.}
}
\value{
Numeric value if \code{gains} is a vector, numeric matrix if 
\code{gains} is a matrix.
}
\description{
Calculates prices based on initial balance and vector of gains.
}
\examples{
# Simulate daily gains over a 5-year period
set.seed(123)
gains <- rnorm(n = 252 * 5, mean = 0.001, sd = 0.02)

# Plot balance over time if initial balance is $10,000
prices <- gains_prices(gains)
plot(prices)


}
