% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_effects.R
\name{RandomEffectsModel}
\alias{RandomEffectsModel}
\title{The core "model" class for sampling random effects.}
\description{
Stores current model state, prior parameters, and procedures for
sampling from the conditional posterior of each parameter.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{rfx_model_ptr}}{External pointer to a C++ StochTree::RandomEffectsModel class}

\item{\code{num_groups}}{Number of groups in the random effects model}

\item{\code{num_components}}{Number of components (i.e. dimension of basis) in the random effects model}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RandomEffectsModel-new}{\code{RandomEffectsModel$new()}}
\item \href{#method-RandomEffectsModel-sample_random_effect}{\code{RandomEffectsModel$sample_random_effect()}}
\item \href{#method-RandomEffectsModel-predict}{\code{RandomEffectsModel$predict()}}
\item \href{#method-RandomEffectsModel-set_working_parameter}{\code{RandomEffectsModel$set_working_parameter()}}
\item \href{#method-RandomEffectsModel-set_group_parameters}{\code{RandomEffectsModel$set_group_parameters()}}
\item \href{#method-RandomEffectsModel-set_working_parameter_cov}{\code{RandomEffectsModel$set_working_parameter_cov()}}
\item \href{#method-RandomEffectsModel-set_group_parameter_cov}{\code{RandomEffectsModel$set_group_parameter_cov()}}
\item \href{#method-RandomEffectsModel-set_variance_prior_shape}{\code{RandomEffectsModel$set_variance_prior_shape()}}
\item \href{#method-RandomEffectsModel-set_variance_prior_scale}{\code{RandomEffectsModel$set_variance_prior_scale()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectsModel-new"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectsModel-new}{}}}
\subsection{Method \code{new()}}{
Create a new RandomEffectsModel object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectsModel$new(num_components, num_groups)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num_components}}{Number of "components" or bases defining the random effects regression}

\item{\code{num_groups}}{Number of random effects groups}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{RandomEffectsModel} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectsModel-sample_random_effect"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectsModel-sample_random_effect}{}}}
\subsection{Method \code{sample_random_effect()}}{
Sample from random effects model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectsModel$sample_random_effect(
  rfx_dataset,
  residual,
  rfx_tracker,
  rfx_samples,
  keep_sample,
  global_variance,
  rng
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rfx_dataset}}{Object of type \code{RandomEffectsDataset}}

\item{\code{residual}}{Object of type \code{Outcome}}

\item{\code{rfx_tracker}}{Object of type \code{RandomEffectsTracker}}

\item{\code{rfx_samples}}{Object of type \code{RandomEffectSamples}}

\item{\code{keep_sample}}{Whether sample should be retained in \code{rfx_samples}. If \code{FALSE}, the state of \code{rfx_tracker} will be updated, but the parameter values will not be added to the sample container. Samples are commonly discarded due to burn-in or thinning.}

\item{\code{global_variance}}{Scalar global variance parameter}

\item{\code{rng}}{Object of type \code{CppRNG}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectsModel-predict"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectsModel-predict}{}}}
\subsection{Method \code{predict()}}{
Predict from (a single sample of a) random effects model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectsModel$predict(rfx_dataset, rfx_tracker)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rfx_dataset}}{Object of type \code{RandomEffectsDataset}}

\item{\code{rfx_tracker}}{Object of type \code{RandomEffectsTracker}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector of predictions with size matching number of observations in rfx_dataset
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectsModel-set_working_parameter"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectsModel-set_working_parameter}{}}}
\subsection{Method \code{set_working_parameter()}}{
Set value for the "working parameter." This is typically
used for initialization, but could also be used to interrupt
or override the sampler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectsModel$set_working_parameter(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Parameter input}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectsModel-set_group_parameters"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectsModel-set_group_parameters}{}}}
\subsection{Method \code{set_group_parameters()}}{
Set value for the "group parameters." This is typically
used for initialization, but could also be used to interrupt
or override the sampler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectsModel$set_group_parameters(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Parameter input}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectsModel-set_working_parameter_cov"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectsModel-set_working_parameter_cov}{}}}
\subsection{Method \code{set_working_parameter_cov()}}{
Set value for the working parameter covariance. This is typically
used for initialization, but could also be used to interrupt
or override the sampler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectsModel$set_working_parameter_cov(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Parameter input}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectsModel-set_group_parameter_cov"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectsModel-set_group_parameter_cov}{}}}
\subsection{Method \code{set_group_parameter_cov()}}{
Set value for the group parameter covariance. This is typically
used for initialization, but could also be used to interrupt
or override the sampler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectsModel$set_group_parameter_cov(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Parameter input}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectsModel-set_variance_prior_shape"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectsModel-set_variance_prior_shape}{}}}
\subsection{Method \code{set_variance_prior_shape()}}{
Set shape parameter for the group parameter variance prior.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectsModel$set_variance_prior_shape(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Parameter input}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectsModel-set_variance_prior_scale"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectsModel-set_variance_prior_scale}{}}}
\subsection{Method \code{set_variance_prior_scale()}}{
Set shape parameter for the group parameter variance prior.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectsModel$set_variance_prior_scale(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Parameter input}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
}
