% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizers_free.R
\name{run_SQN_free}
\alias{run_SQN_free}
\title{Run SQN optimizer in free-mode}
\usage{
run_SQN_free(optimizer, x, step_size)
}
\arguments{
\item{optimizer}{An `SQN_free` optimizer, for which its last request must have been served. Will be updated in-place.}

\item{x}{Current values of the variables being optimized. Must be a numeric vector. Will be updated in-place.}

\item{step_size}{Step size for the quasi-Newton update.}
}
\value{
A request with the next piece of required information. The output will be a list with the following levels:
\itemize{
   \item{task} Requested task (one of "calc_grad", "calc_grad_big_batch", "calc_hess_vec").
   \item{requested_on} \itemize{
       \item{req_x} Values of `x` at which the requested information (gradient/Hessian) must be calculated.
       \item{req_vec} Vector by which the Hessian must be multiplied. Will output `NULL` when this
       calculation is not needed.
   }
   \item{info} \itemize{
      \item{x_changed_in_run} Whether the `x` vector was updated.
      \item{iteration_number} Current iteration number (in terms of quasi-Newton updates).
      \item{iteration_info} Information about potential problems encountered during the iteration.
   } 
}
}
\description{
Run the next step of an SQN optimization procedure, after the last requested calculation
has been fed to the optimizer. When run for the first time, there is no request, so the function just
needs to be run on the object as it is returned from function `SQN_free`.
}
\seealso{
\link{SQN_free}
}
