% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs.R
\name{gibbs}
\alias{gibbs}
\alias{gibbs.stcos}
\alias{gibbs.stcos.raw}
\title{Gibbs Sampler for STCOS Model}
\usage{
gibbs.stcos(prep, R, report.period = R + 1, burn = 0, thin = 1,
  hyper = NULL, init = NULL)

gibbs.stcos.raw(z, v, H, S, K.inv, R, report.period = R + 1, burn = 0,
  thin = 1, init = NULL, fixed = NULL, hyper = NULL)
}
\arguments{
\item{prep}{An \code{STCOSprep} object.}

\item{R}{Number of MCMC reps.}

\item{report.period}{Gibbs sampler will report progress each time this many
iterations are completed.}

\item{burn}{Burn this many of \code{R} the draws, before saving history.}

\item{thin}{After burn-ikn period, save one out of every \code{thin} draws.}

\item{hyper}{A list containing the following hyperparameter values:
\code{a.sig2mu}, \code{a.sig2K}, \code{a.sig2xi}, \code{b.sig2mu},
\code{b.sig2K}, \code{b.sig2xi}. Any hyperparameters which are not
specified are set to a default value of 2.}

\item{init}{A list containing the following initial values for the MCMC:
\code{sig2mu}, \code{sig2xi}, \code{sig2K}, \code{mu_B}, \code{eta},
\code{xi}. Any values which are not specified are set to arbitrary
choices.}

\item{z}{Vector which represents the outcome; assumed to be direct
estimates from the survey.}

\item{v}{Vector which represents direct variance estimates from the survey.}

\item{H}{Matrix of overlaps between source and fine-level supports.}

\item{S}{Design matrix for basis decomposition.}

\item{K.inv}{Inverse of the \eqn{K} matrix, which is the covariance of the
random coefficient \eqn{\eta}}

\item{fixed}{A list specifying which parameters to keep fixed in the MCMC.
This can normally be left blank. If elements \code{sig2mu},
\code{sig2xi}, or \code{sig2K} are specified they should be boolean,
where TRUE means fixed (i.e. not drawn). If elements \code{mu_B},
\code{eta}, or \code{xi} are specified, they should each be a vector
of indicies; the specified indices are to be treated as fixed (i.e.
not drawn).}
}
\value{
An \code{stcos} object which contains draws from the sampler.
}
\description{
Run the Gibbs sampling algorithm for the STCOS model. \code{gibbs.stcos}
presents a simplified interface, while \code{gibbs.stcos.raw} allows
all inputs to be specified separately.
}
\examples{
\dontrun{
basis <- SpaceTimeBisquareBasis$new(x, y, t, w.s, w.t)
sp <- STCOSPrep$new(fine_domain = dom.fine,
    fine_domain_geo_name = "GEO_ID",
    basis = basis, basis_mc_reps = 500)
out1 <- gibbs.stcos(sp, R = 10000, burn = 0, thin = 1)

out2 <- gibbs.stcos.raw(z = sp$get_z(), S = sp$get_reduced_S(),
    v = sp$get_v(), K.inv = sp$get_Kinv(), H = sp$get_H(),
    R = 10000, burn = 0, thin = 1)
}
}
