% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandit_posterior.R
\name{bandit_posterior}
\alias{bandit_posterior}
\title{bandit posterior}
\usage{
bandit_posterior(data, prior = c(m1_good = 0.5, m2_good = 0.5),
  win_probs = c(good = 1/2, bad = 1/3))
}
\arguments{
\item{data}{data frame containing win loss data}

\item{prior}{prior vector containing the probabilities of Machine 1 and Machine 2 being good, defaults to 0.5 and 0.5 respectively.}

\item{win_probs}{vector containing the probabilities of winning on the good and bad machine respectively.}
}
\value{
A vector containing the posterior probability of Machine 1 and Machine 2 being the good machine.
}
\description{
Utility function for calculating the posterior probability of each machine being "good" in 
two armed bandit problem. Calculated result is based on observed win loss data, prior belief about 
which machine is good and the probability of the good and bad machine paying out.
}
\examples{
data = data.frame(machine = c(1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L), 
                  outcome = c("W", "L", "W", "L", "L", "W", "L", "L", "L", "W"))
bandit_posterior(data)
plot_bandit_posterior(data)

}
\seealso{
\code{\link{bandit_sim}} to generate data and
         \code{\link{plot_bandit_posterior}} to visualize.
}
