% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_meta_analysis_expressions.R
\name{expr_meta_bayes}
\alias{expr_meta_bayes}
\title{Making expression containing Bayesian random-effects meta-analysis.}
\usage{
expr_meta_bayes(
  data,
  d = prior("norm", c(mean = 0, sd = 0.3)),
  tau = prior("invgamma", c(shape = 1, scale = 0.15)),
  k = 2,
  messages = TRUE,
  ...
)
}
\arguments{
\item{data}{data frame containing the variables for effect size \code{y},
standard error \code{SE}, \code{labels}, and moderators per study.}

\item{d}{\code{prior} distribution on the average effect size \code{d}. The
prior probability density function is defined via \code{\link[metaBMA]{prior}}.}

\item{tau}{\code{prior} distribution on the between-study heterogeneity
\code{tau} (i.e., the standard deviation of the study effect sizes
\code{dstudy} in a random-effects meta-analysis. A (nonnegative) prior
probability density function is defined via \code{\link[metaBMA]{prior}}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{further arguments passed to \code{rstan::sampling} (see
\code{\link[rstan]{stanmodel-method-sampling}}). Relevant MCMC settings
concern the number of warmup samples that are discarded
(\code{warmup=500}), the total number of iterations per chain
(\code{iter=2000}), the number of MCMC chains (\code{chains=4}), whether
multiple cores should be used (\code{cores=4}), and control arguments that
make the sampling in Stan more robust, for instance:
\code{control=list(adapt_delta=.97)}.}
}
\description{
Making expression containing Bayesian random-effects meta-analysis.
}
\examples{
\donttest{
# setup
set.seed(123)
library(statsExpressions)

# let's create a dataframe
df_results <-
  structure(
    .Data = list(estimate = c(
      0.382047603321706, 0.780783111514665,
      0.425607573765058, 0.558365541235078, 0.956473848429961
    ), std.error = c(
      0.0465576338644502,
      0.0330218199731529, 0.0362834986178494, 0.0480571500648261, 0.062215818388157
    ), t.value = c(
      8.20590677855356, 23.6444603038067, 11.7300588415607,
      11.6187818146078, 15.3734833553524
    ), conf.low = c(
      0.290515146096969,
      0.715841986960399, 0.354354575031406, 0.46379116008131, 0.827446138277154
    ), conf.high = c(
      0.473580060546444, 0.845724236068931, 0.496860572498711,
      0.652939922388847, 1.08550155858277
    ), p.value = c(
      3.28679518728519e-15,
      4.04778497135963e-75, 7.59757330804449e-29, 5.45155840151592e-26,
      2.99171217913312e-13
    ), df.residual = c(
      394L, 358L, 622L, 298L,
      22L
    )),
    row.names = c(NA, -5L),
    class = c("tbl_df", "tbl", "data.frame")
  )

# making subtitle
expr_meta_bayes(
  data = df_results,
  k = 3,
  messages = FALSE,
  # additional arguments given to `metaBMA`
  iter = 5000,
  summarize = "integrate",
  control = list(adapt_delta = 0.99, max_treedepth = 15)
)
}
}
