% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statquote.R
\name{as.latex}
\alias{as.latex}
\title{Coerces statquote objects to strings suitable for LaTeX}
\usage{
as.latex(quotes, form = "\\\\epigraph{\%s}{\%s}\\n\\n", cite = TRUE)
}
\arguments{
\item{quotes}{an object of class \code{statquote} returned from functions such as
\code{\link{search_quotes}} or \code{\link{statquote}}}

\item{form}{structure of the LaTeX output for the text (first argument)
and source (second argument) passed to \code{\link{sprintf}}}

\item{cite}{logical; should the \code{cite} field be included in the source output?}
}
\value{
character vector of formatted LaTeX quotes
}
\description{
This function coerces statquote objects to strings suitable for rendering in LaTeX.
Quotes and (potential LaTeX) sources are placed within suitable "\code{epigraph}" output
format via the \code{\link{sprintf}} function.
}
\examples{

ll <- search_quotes("Tukey")
as.latex(ll)

}
\seealso{
\code{\link{as.data.frame.statquote}}, \code{\link{as.markdown}}
}
\author{
Phil Chalmers
}
