% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{test.spear2}
\alias{test.spear2}
\title{Hypothesis test for a 2-group Spearman correlation difference}
\usage{
test.spear2(cor1, cor2, n1, n2)
}
\arguments{
\item{cor1}{estimated Spearman correlation for group 1}

\item{cor2}{estimated Spearman correlation for group 2}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of correlation difference
\item z - z test statistic
\item p - two-sided p-value
}
}
\description{
Computes a z test for a difference of population Spearman correlations in a
2-group design. The test statistic uses a Bonett-Wright standard error for
each Spearman correlation. The hypothesis testing results should be
accompanied with a confidence interval for a difference in population
Spearman correlation values.
}
\examples{
test.spear2(.684, .437, 100, 125)

# Should return:
# Estimate        z          p
#    0.247 2.498645 0.01246691


}
\references{
\insertRef{Bonett2000}{statpsych}
}
\seealso{
\link[statpsych]{ci.spear2}
}
