% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{pi.cor}
\alias{pi.cor}
\title{Prediction limit for an estimated correlation}
\usage{
pi.cor(alpha, cor, n0, n)
}
\arguments{
\item{alpha}{alpha value for 1-alpha confidence}

\item{cor}{estimated Pearson correlation from prior study}

\item{n0}{sample size used to estimate correlation in prior study}

\item{n}{planned sample size of future study}
}
\value{
Returns a prediction interval of an estimated correlation in a
future study
}
\description{
Computes approximate prediction interval for the estimated Pearson
correlation in a future study with a planned sample size of n. The
prediction interval uses a correlation estimate from a prior study
that had a sample size of n0.
}
\examples{
pi.cor(.1, .761, 50, 100)

# Should return:
#         LL        UL
#  0.6034092 0.8573224
 

}
