% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.utilities.R
\name{ERRVL}
\alias{ERRVL}
\title{Return the first argument passed (out of any number) that is not a
\code{try-error} (result of \code{\link[base]{try}} encountering an error.}
\usage{
ERRVL(...)
}
\arguments{
\item{\dots}{Expressions to be tested; usually outputs of
\code{\link[base]{try}}.}
}
\value{
The first argument that is not a \code{try-error}. Stops
with an error if all are.
}
\description{
This function is inspired by \code{\link{NVL}}, and simply returns the first
argument that is not a \code{try-error}, raising an error if all arguments
are \code{try-error}s.
}
\note{
This function uses lazy evaluation, so, for example \code{ERRVL(1, stop("Error!"))} will never evaluate the \code{\link{stop}} call and will
not produce an error, whereas \code{ERRVL(try(solve(0)), stop("Error!"))} would.

In addition, all expressions after the first may contain a \code{.},
which is substituted with the \code{try-error} object returned by the
previous expression.
}
\examples{

print(ERRVL(1,2,3)) # 1
print(ERRVL(try(solve(0)),2,3)) # 2
print(ERRVL(1, stop("Error!"))) # No error

\dontrun{
# Error:
print(ERRVL(try(solve(0), silent=TRUE),
            stop("Error!")))

# Error with an elaborate message:
print(ERRVL(try(solve(0), silent=TRUE),
            stop("Stopped with an error: ", .)))
}
}
\seealso{
\code{\link[base]{try}}, \code{\link[base]{inherits}}
}
\keyword{utilities}
